/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class Value<S> {
    private final S underlyingObject;

    public Value(S underlyingObject) {
        this.underlyingObject = underlyingObject;
    }

    public String asString() {
        if (this.underlyingObject instanceof List) {
            try {
                List composite = (List)this.underlyingObject;
                return composite.stream().map(f -> f.getValue().asString()).collect(Collectors.joining(" "));
            }
            catch (ClassCastException composite) {
                // empty catch block
            }
        }
        if (this.underlyingObject instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)this.underlyingObject;
            return new String(byteBuffer.array());
        }
        return ArrayUtils.toString(this.underlyingObject);
    }

    public double asNumber() {
        if (this.underlyingObject != null) {
            try {
                return this.underlyingObject instanceof Boolean ? (((Boolean)this.underlyingObject).booleanValue() ? 1.0 : 0.0) : Double.parseDouble(this.asString());
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public S getUnderlyingObject() {
        return this.underlyingObject;
    }

    public String toString() {
        return Objects.toString(this.underlyingObject);
    }

    public double[] asVector() {
        double[] doubles;
        if (this.underlyingObject instanceof double[]) {
            doubles = (double[])this.underlyingObject;
        } else if (this.underlyingObject instanceof String) {
            String string = (String)this.underlyingObject;
            doubles = this.parseVectorString(string);
        } else if (this.underlyingObject instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)this.underlyingObject;
            String string = StandardCharsets.UTF_8.decode(byteBuffer).toString();
            doubles = this.parseVectorString(string);
        } else {
            double v = this.asNumber();
            doubles = new double[]{v};
        }
        return doubles;
    }

    private double[] parseVectorString(String string) {
        double[] doubles;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonParser parser = objectMapper.createParser(string);
            Double[] ar = (Double[])objectMapper.readValue(parser, Double[].class);
            doubles = Arrays.stream(ar).mapToDouble(Double::doubleValue).toArray();
        }
        catch (Exception e) {
            try {
                JsonParser parser = objectMapper.createParser(string);
                MappingIterator iterator = objectMapper.readValues(parser, Double.class);
                doubles = iterator.readAll().stream().mapToDouble(Double::doubleValue).toArray();
            }
            catch (Exception e2) {
                doubles = new double[]{};
            }
        }
        return doubles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Value value = (Value)o;
        return Objects.equals(this.underlyingObject, value.underlyingObject);
    }

    public int hashCode() {
        return Objects.hash(this.underlyingObject);
    }
}

