/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.IndependentFeaturesDataDistribution;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.utils.DataUtils;

class IndependentFeaturesDataDistributionTest {
    IndependentFeaturesDataDistributionTest() {
    }

    @Test
    void testSamples() {
        ArrayList<NumericFeatureDistribution> featureDistributions = new ArrayList<NumericFeatureDistribution>(3);
        double[] doubles1 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)10);
        double[] doubles2 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)10);
        double[] doubles3 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)10);
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles1));
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles2));
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles3));
        IndependentFeaturesDataDistribution independentFeaturesDataDistribution = new IndependentFeaturesDataDistribution(featureDistributions);
        org.junit.jupiter.api.Assertions.assertEquals((int)1000, (int)independentFeaturesDataDistribution.getAllSamples().size());
        List samples = independentFeaturesDataDistribution.sample(3);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)samples);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)samples.size());
        for (PredictionInput sample : samples) {
            Assertions.assertThat((double)((Feature)sample.getFeatures().get(0)).getValue().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
            Assertions.assertThat((double)((Feature)sample.getFeatures().get(1)).getValue().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
            Assertions.assertThat((double)((Feature)sample.getFeatures().get(2)).getValue().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
        }
    }

    @Test
    void testLargerSamples() {
        ArrayList<NumericFeatureDistribution> featureDistributions = new ArrayList<NumericFeatureDistribution>(3);
        double[] doubles1 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)3);
        double[] doubles2 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)3);
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles1));
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles2));
        IndependentFeaturesDataDistribution independentFeaturesDataDistribution = new IndependentFeaturesDataDistribution(featureDistributions);
        List samples = independentFeaturesDataDistribution.sample(300);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)samples);
        org.junit.jupiter.api.Assertions.assertEquals((int)300, (int)samples.size());
        for (PredictionInput sample : samples) {
            Assertions.assertThat((double)((Feature)sample.getFeatures().get(0)).getValue().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
            Assertions.assertThat((double)((Feature)sample.getFeatures().get(1)).getValue().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
        }
    }

    @Test
    void testAsFeatureDistributions() {
        ArrayList<NumericFeatureDistribution> featureDistributions = new ArrayList<NumericFeatureDistribution>(3);
        double[] doubles1 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)3);
        double[] doubles2 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)3);
        double[] doubles3 = DataUtils.generateSamples((double)0.0, (double)1.0, (int)3);
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles1));
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles2));
        featureDistributions.add(new NumericFeatureDistribution(TestUtils.getMockedNumericFeature(), doubles3));
        IndependentFeaturesDataDistribution independentFeaturesDataDistribution = new IndependentFeaturesDataDistribution(featureDistributions);
        List list = independentFeaturesDataDistribution.asFeatureDistributions();
        org.junit.jupiter.api.Assertions.assertEquals((Object)list, featureDistributions);
    }

    @Test
    void testEmptyCartesianProduct() {
        Collection lists = IndependentFeaturesDataDistribution.cartesianProduct(Collections.emptyList());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lists);
        Assertions.assertThat((Iterable)lists).isEmpty();
    }

    @Test
    void testCartesianProduct() {
        ArrayList<Collection> enumerations = new ArrayList<Collection>(3);
        enumerations.add(Arrays.stream(DataUtils.generateSamples((double)0.0, (double)1.0, (int)3)).boxed().collect(Collectors.toList()));
        enumerations.add(Arrays.stream(DataUtils.generateSamples((double)0.0, (double)1.0, (int)3)).boxed().collect(Collectors.toList()));
        enumerations.add(Arrays.stream(DataUtils.generateSamples((double)0.0, (double)1.0, (int)3)).boxed().collect(Collectors.toList()));
        Collection lists = IndependentFeaturesDataDistribution.cartesianProduct(enumerations);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lists);
        ((IterableAssert)Assertions.assertThat((Iterable)lists).isNotEmpty()).hasSize(27);
    }
}

