/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.utils.WeightedLinearRegressionResults;

class WeightedLinearRegressionResultsTest {
    WeightedLinearRegressionResultsTest() {
    }

    @Test
    void testWLRResultsNoIntercept() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}};
        double[] flatCoef = new double[]{5.0, 1.0, -1.0, 3.0};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, false, 1.0, 0.01);
        Assertions.assertArrayEquals((double[])flatCoef, (double[])wlrr.getCoefficients());
        Assertions.assertEquals((double)0.0, (double)wlrr.getIntercept());
        Assertions.assertEquals((double)1.0, (double)wlrr.getGof());
        Assertions.assertEquals((double)0.01, (double)wlrr.getMSE());
    }

    @Test
    void testWLRResultWithIntercept() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}};
        double[] flatCoef = new double[]{5.0, 1.0, -1.0};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1.0, 0.01);
        Assertions.assertArrayEquals((double[])flatCoef, (double[])wlrr.getCoefficients());
        Assertions.assertEquals((double)3.0, (double)wlrr.getIntercept());
        Assertions.assertEquals((double)1.0, (double)wlrr.getGof());
        Assertions.assertEquals((double)0.01, (double)wlrr.getMSE());
    }

    @Test
    void testPredictions() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}, {5.0}};
        double[][] x = new double[][]{{1.0, 5.0, 3.0, -2.0}, {10.0, -1.0, 0.0, 4.0}, {-2.0, 7.5, 6.0, -3.3}};
        double[] y = new double[]{6.0, 66.0, -13.4};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1.0, 0.01);
        Assertions.assertArrayEquals((double[])y, (double[])wlrr.predict((double[][])x), (double)1.0E-6);
    }

    @Test
    void testPredictionsWrongNumFeatures() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}, {5.0}};
        double[][] x = new double[][]{{1.0, 5.0}, {10.0, -1.0}, {-2.0, 7.5}};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1.0, 0.01);
        Assertions.assertThrows(IllegalArgumentException.class, () -> wlrr.predict(x));
    }
}

