/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualConfigurationFactory;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualResult;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.DataDomain;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureDomain;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.optaplanner.core.config.solver.SolverConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterfactualExplainer
implements LocalExplainer<CounterfactualResult> {
    private static final Logger logger = LoggerFactory.getLogger(CounterfactualExplainer.class);
    private final List<Output> goal;
    private final DataDomain dataDomain;
    private final List<Boolean> constraints;
    private final SolverConfig solverConfig;
    private final Executor executor;
    private final DataDistribution dataDistribution;

    protected CounterfactualExplainer(DataDistribution dataDistribution, DataDomain dataDomain, List<Boolean> contraints, List<Output> goal, SolverConfig solverConfig, Executor executor) {
        this.dataDistribution = dataDistribution;
        this.dataDomain = dataDomain;
        this.constraints = contraints;
        this.goal = goal;
        this.solverConfig = solverConfig;
        this.executor = executor;
    }

    public static Builder builder(List<Output> goal, List<Boolean> constraints, DataDomain dataDomain) {
        return new Builder(goal, constraints, dataDomain);
    }

    private List<CounterfactualEntity> createEntities(PredictionInput predictionInput) {
        return IntStream.range(0, predictionInput.getFeatures().size()).mapToObj(featureIndex -> {
            Feature feature = predictionInput.getFeatures().get(featureIndex);
            Boolean isConstrained = this.constraints.get(featureIndex);
            FeatureDomain featureDomain = this.dataDomain.getFeatureDomains().get(featureIndex);
            FeatureDistribution featureDistribution = Optional.ofNullable(this.dataDistribution).map(dd -> dd.asFeatureDistributions().get(featureIndex)).orElse(null);
            return CounterfactualEntityFactory.from(feature, isConstrained, featureDomain, featureDistribution);
        }).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<CounterfactualResult> explainAsync(Prediction prediction, PredictionProvider model) {
        List<CounterfactualEntity> entities = this.createEntities(prediction.getInput());
        UUID problemId = UUID.randomUUID();
        CompletableFuture<List> cfEntities = CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.executor);
        CompletionStage cfOutputs = cfEntities.thenCompose(s -> model.predictAsync(List.of(new PredictionInput(s.stream().map(CounterfactualEntity::asFeature).collect(Collectors.toList())))));
        return CompletableFuture.allOf(new CompletableFuture[]{cfOutputs, cfEntities}).thenApply(arg_0 -> CounterfactualExplainer.lambda$explainAsync$4(cfEntities, (CompletableFuture)cfOutputs, arg_0));
    }

    private static /* synthetic */ CounterfactualResult lambda$explainAsync$4(CompletableFuture cfEntities, CompletableFuture cfOutputs, Void v) {
        return new CounterfactualResult((List)cfEntities.join(), (List)cfOutputs.join());
    }

    public static class Builder {
        private final DataDomain dataDomain;
        private final List<Boolean> constraints;
        private final List<Output> goal;
        private DataDistribution dataDistribution = null;
        private Executor executor = ForkJoinPool.commonPool();
        private SolverConfig solverConfig = null;

        private Builder(List<Output> goal, List<Boolean> constraints, DataDomain dataDomain) {
            this.goal = goal;
            this.constraints = constraints;
            this.dataDomain = dataDomain;
        }

        public Builder withDataDistribution(DataDistribution dataDistribution) {
            this.dataDistribution = dataDistribution;
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withSolverConfig(SolverConfig solverConfig) {
            this.solverConfig = solverConfig;
            return this;
        }

        public CounterfactualExplainer build() {
            if (this.solverConfig == null) {
                this.solverConfig = CounterfactualConfigurationFactory.builder().build();
            }
            return new CounterfactualExplainer(this.dataDistribution, this.dataDomain, this.constraints, this.goal, this.solverConfig, this.executor);
        }
    }
}

