/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public class GenericFeatureDistribution
implements FeatureDistribution {
    private final Feature feature;
    private final List<Value> values;
    private final Random random;

    public GenericFeatureDistribution(Feature feature, List<Value> values) {
        this(feature, values, new SecureRandom());
    }

    public GenericFeatureDistribution(Feature feature, List<Value> values, Random random) {
        this.feature = feature;
        this.values = Collections.unmodifiableList(values);
        this.random = random;
    }

    @Override
    public Feature getFeature() {
        return this.feature;
    }

    @Override
    public Value sample() {
        if (this.values.isEmpty()) {
            return new Value(null);
        }
        List<Value> samples = this.sample(1);
        if (samples.isEmpty()) {
            return new Value(null);
        }
        return samples.get(0);
    }

    @Override
    public List<Value> sample(int sampleSize) {
        return DataUtils.sampleWithReplacement(this.values, sampleSize, this.random);
    }

    @Override
    public List<Value> getAllSamples() {
        ArrayList<Value> copy = new ArrayList<Value>(this.values);
        Collections.shuffle(copy);
        return copy;
    }
}

