/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.GenericFeatureDistribution;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

class GenericFeatureDistributionTest {
    GenericFeatureDistributionTest() {
    }

    @Test
    void testNumericSamples() {
        Feature feature = TestUtils.getMockedNumericFeature();
        double[] doubles = DataUtils.generateSamples((double)0.0, (double)10.0, (int)10);
        List values = Arrays.stream(doubles).mapToObj(Value::new).collect(Collectors.toList());
        GenericFeatureDistribution numericFeatureDistribution = new GenericFeatureDistribution(feature, values);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)numericFeatureDistribution.getAllSamples().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)numericFeatureDistribution.sample(3).size());
        Assertions.assertThat((double)numericFeatureDistribution.sample().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(10.0));
        org.junit.jupiter.api.Assertions.assertEquals((int)19, (int)numericFeatureDistribution.sample(19).size());
    }

    @Test
    void testStringSample() {
        Feature feature = TestUtils.getMockedNumericFeature();
        String[] words = "a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ");
        List values = Arrays.stream(words).map(Value::new).collect(Collectors.toList());
        GenericFeatureDistribution stringFeatureDistribution = new GenericFeatureDistribution(feature, values);
        org.junit.jupiter.api.Assertions.assertEquals((int)26, (int)stringFeatureDistribution.getAllSamples().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)stringFeatureDistribution.sample(3).size());
        Assertions.assertThat((String)stringFeatureDistribution.sample().asString()).isBetween("a", "z");
        org.junit.jupiter.api.Assertions.assertEquals((int)55, (int)stringFeatureDistribution.sample(55).size());
    }
}

