/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class CategoricalEntity
extends AbstractEntity<String> {
    private Set<String> allowedCategories;

    public CategoricalEntity() {
    }

    private CategoricalEntity(String originalValue, String featureName, Set<String> allowedCategories, boolean constrained) {
        super(originalValue, featureName, constrained);
        this.allowedCategories = allowedCategories;
    }

    public static CategoricalEntity from(Feature originalFeature, Set<String> categories, boolean constrained) {
        return new CategoricalEntity(originalFeature.getValue().asString(), originalFeature.getName(), categories, constrained);
    }

    public static CategoricalEntity from(Feature originalFeature, Set<String> categories) {
        return CategoricalEntity.from(originalFeature, categories, false);
    }

    @ValueRangeProvider(id="categoricalRange")
    public Set<String> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public double distance() {
        return ((String)this.proposedValue).equals(this.originalValue) ? 0.0 : 1.0;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newCategoricalFeature(this.featureName, (String)this.proposedValue);
    }

    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public String getProposedValue() {
        return (String)this.proposedValue;
    }

    public void setProposedValue(String proposedValue) {
        this.proposedValue = proposedValue;
    }
}

