/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.security.SecureRandom;
import org.kie.kogito.explainability.model.EncodingParams;
import org.kie.kogito.explainability.model.PerturbationContext;

public class LimeConfig {
    private static final int DEFAULT_NO_OF_SAMPLES = 300;
    private static final double DEFAULT_SEPARABLE_DATASET_RATIO = 0.99;
    public static final int DEFAULT_NO_OF_RETRIES = 3;
    private static final boolean DEFAULT_ADAPT_DATASET_VARIANCE = false;
    private static final boolean DEFAULT_PENALIZE_BALANCE_SPARSE = false;
    private static final boolean DEFAULT_PROXIMITY_FILTER = true;
    private static final double DEFAULT_PROXIMITY_THRESHOLD = 0.8;
    private static final Number DEFAULT_PROXIMITY_FILTERED_DATASET_MIN = 10;
    private static final double DEFAULT_PROXIMITY_KERNEL_WIDTH = 0.675;
    private static final double DEFAULT_ENCODING_CLUSTER_THRESHOLD = 0.1;
    private static final double DEFAULT_ENCODING_GAUSSIAN_FILTER_WIDTH = 1.0;
    private double separableDatasetRatio = 0.99;
    private int noOfSamples = 300;
    private int noOfRetries = 3;
    private PerturbationContext perturbationContext = new PerturbationContext(new SecureRandom(), 1);
    private boolean adaptDatasetVariance = false;
    private boolean penalizeBalanceSparse = false;
    private boolean proximityFilter = true;
    private double proximityThreshold = 0.8;
    private Number proximityFilteredDatasetMinimum = DEFAULT_PROXIMITY_FILTERED_DATASET_MIN;
    private double proximityKernelWidth = 0.675;
    private EncodingParams encodingParams = new EncodingParams(1.0, 0.1);

    public LimeConfig withSeparableDatasetRatio(double separableDatasetRatio) {
        this.separableDatasetRatio = separableDatasetRatio;
        return this;
    }

    public LimeConfig withPerturbationContext(PerturbationContext perturbationContext) {
        this.perturbationContext = perturbationContext;
        return this;
    }

    public LimeConfig withAdaptiveVariance(boolean adaptDatasetVariance) {
        this.adaptDatasetVariance = adaptDatasetVariance;
        return this;
    }

    public LimeConfig withPenalizeBalanceSparse(boolean penalizeBalanceSparse) {
        this.penalizeBalanceSparse = penalizeBalanceSparse;
        return this;
    }

    public LimeConfig withRetries(int noOfRetries) {
        this.noOfRetries = noOfRetries;
        return this;
    }

    public LimeConfig withSamples(int noOfSamples) {
        this.noOfSamples = noOfSamples;
        return this;
    }

    public LimeConfig withProximityFilter(boolean proximityFilter) {
        this.proximityFilter = proximityFilter;
        return this;
    }

    public LimeConfig withProximityThreshold(double proximityThreshold) {
        this.proximityThreshold = proximityThreshold;
        return this;
    }

    public LimeConfig withProximityKernelWidth(double proximityKernelWidth) {
        this.proximityKernelWidth = proximityKernelWidth;
        return this;
    }

    public int getNoOfRetries() {
        return this.noOfRetries;
    }

    public int getNoOfSamples() {
        return this.noOfSamples;
    }

    public PerturbationContext getPerturbationContext() {
        return this.perturbationContext;
    }

    public boolean adaptDatasetVariance() {
        return this.adaptDatasetVariance;
    }

    public double getSeparableDatasetRatio() {
        return this.separableDatasetRatio;
    }

    public boolean isPenalizeBalanceSparse() {
        return this.penalizeBalanceSparse;
    }

    public boolean isProximityFilter() {
        return this.proximityFilter;
    }

    public double getProximityThreshold() {
        return this.proximityThreshold;
    }

    public Number getProximityFilteredDatasetMinimum() {
        return this.proximityFilteredDatasetMinimum;
    }

    public LimeConfig withProximityFilteredDatasetMinimum(Number proximityFilteredDatasetMinimum) {
        this.proximityFilteredDatasetMinimum = proximityFilteredDatasetMinimum;
        return this;
    }

    public double getProximityKernelWidth() {
        return this.proximityKernelWidth;
    }

    public EncodingParams getEncodingParams() {
        return this.encodingParams;
    }

    public LimeConfig withEncodingParams(EncodingParams encodingParams) {
        this.encodingParams = encodingParams;
        return this;
    }
}

