/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProximityFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProximityFilter.class);
    private final double proximityThreshold;
    private final double proximityFilteredDatasetMinimum;

    ProximityFilter(double proximityThreshold, double proximityFilteredDatasetMinimum) {
        this.proximityThreshold = proximityThreshold;
        this.proximityFilteredDatasetMinimum = proximityFilteredDatasetMinimum;
    }

    void apply(List<Pair<double[], Double>> trainingSet, double[] sampleWeights) {
        boolean enoughSamples;
        if (trainingSet == null || sampleWeights == null) {
            LOGGER.error("applied filter on null training set / weights");
            return;
        }
        if (trainingSet.size() != sampleWeights.length) {
            LOGGER.warn("training set size {} \u2260 weights size {}, not filtering", (Object)trainingSet.size(), (Object)sampleWeights.length);
            return;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = trainingSet.size() - 1; i >= 0; --i) {
            if (!(sampleWeights[i] < this.proximityThreshold)) continue;
            toRemove.add(i);
        }
        double v = this.proximityFilteredDatasetMinimum;
        if (v % 1.0 == 0.0) {
            enoughSamples = (double)(trainingSet.size() - toRemove.size()) > v;
        } else if (v > 1.0) {
            LOGGER.warn("unexpected value for 'Minimum dataset cut' {}, not filtering", (Object)v);
            enoughSamples = false;
        } else {
            boolean bl = enoughSamples = (double)toRemove.size() / (double)trainingSet.size() >= v;
        }
        if (!toRemove.isEmpty() && enoughSamples) {
            for (Integer r : toRemove) {
                trainingSet.remove(r);
            }
            Arrays.fill(sampleWeights, 1.0);
        }
    }
}

