/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureDomain {
    public static final FeatureDomain EMPTY = new FeatureDomain();
    private final Double start;
    private final Double end;
    private final Set<String> categories;

    private FeatureDomain(Double start, Double end, Set<String> categories) {
        this.start = start;
        this.end = end;
        this.categories = categories;
    }

    public static FeatureDomain numerical(double start, double end) {
        return new FeatureDomain(start, end, null);
    }

    public static FeatureDomain numerical(int start, int end) {
        return new FeatureDomain(Double.valueOf(start), Double.valueOf(end), null);
    }

    public static FeatureDomain categorical(Set<String> categories) {
        return new FeatureDomain(null, null, categories);
    }

    public static FeatureDomain categorical(List<String> categories) {
        return new FeatureDomain(null, null, new HashSet<String>(categories));
    }

    public static FeatureDomain categorical(String ... categories) {
        return new FeatureDomain(null, null, new HashSet<String>(Arrays.asList(categories)));
    }

    private FeatureDomain() {
        this.start = null;
        this.end = null;
        this.categories = null;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public boolean isEmpty() {
        return this.start == null && this.end == null && this.categories == null;
    }

    public Double getStart() {
        return this.start;
    }

    public Double getEnd() {
        return this.end;
    }
}

