/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class CounterfactualEntityFactoryTest {
    CounterfactualEntityFactoryTest() {
    }

    @Test
    void testIntegerFactory() {
        int value = 5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"int-feature", (Number)value);
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof IntegerEntity));
    }

    @Test
    void testDoubleFactory() {
        double value = 5.0;
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", (Number)value);
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof DoubleEntity));
    }

    @Test
    void testBooleanFactory() {
        Feature feature = FeatureFactory.newBooleanFeature((String)"bool-feature", (Boolean)false);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)EmptyFeatureDomain.create());
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof BooleanEntity));
    }

    @Test
    void testCategoricalFactoryObject() {
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create((String[])new String[]{"foo", "bar"});
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
    }

    @Test
    void testCategoricalFactorySet() {
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create(Set.of("foo", "bar"));
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
    }

    @Test
    void testCategoricalFactoryList() {
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create(List.of("foo", "bar"));
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
    }
}

