/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class BooleanEntity
extends AbstractEntity<Boolean> {
    public BooleanEntity() {
    }

    private BooleanEntity(Boolean originalValue, String featureName, boolean constrained) {
        super(originalValue, featureName, constrained);
    }

    public static BooleanEntity from(Feature originalFeature, boolean constrained) {
        return new BooleanEntity((Boolean)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), constrained);
    }

    public static BooleanEntity from(Feature originalFeature) {
        return BooleanEntity.from(originalFeature, false);
    }

    @Override
    public double distance() {
        return ((Boolean)this.proposedValue).equals(this.originalValue) ? 0.0 : 1.0;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newBooleanFeature(this.featureName, (Boolean)this.proposedValue);
    }

    @ValueRangeProvider(id="booleanRange")
    public ValueRange<Boolean> getValueRange() {
        return ValueRangeFactory.createBooleanValueRange();
    }

    @PlanningVariable(valueRangeProviderRefs={"booleanRange"})
    public Boolean getProposedValue() {
        return (Boolean)this.proposedValue;
    }

    public void setProposedValue(Boolean proposedValue) {
        this.proposedValue = proposedValue;
    }
}

