/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public class NumericFeatureDistribution
implements FeatureDistribution {
    private final Feature feature;
    private final List<Value> doubles;
    private final Random random;

    public NumericFeatureDistribution(Feature feature, double[] doubles) {
        this(feature, doubles, new SecureRandom());
    }

    public NumericFeatureDistribution(Feature feature, double[] doubles, Random random) {
        this.feature = feature;
        this.doubles = this.toValuesList(doubles);
        this.random = random;
    }

    @Override
    public Feature getFeature() {
        return this.feature;
    }

    @Override
    public Value sample() {
        if (this.doubles.isEmpty()) {
            return new Value(null);
        }
        List<Value> samples = this.sample(1);
        if (samples.isEmpty()) {
            return new Value(null);
        }
        return samples.get(0);
    }

    @Override
    public List<Value> sample(int sampleSize) {
        return DataUtils.sampleWithReplacement(this.doubles, sampleSize, this.random);
    }

    private List<Value> toValuesList(double[] doubles) {
        return Arrays.stream(doubles).boxed().map(Value::new).collect(Collectors.toList());
    }

    @Override
    public List<Value> getAllSamples() {
        ArrayList<Value> values = new ArrayList<Value>(this.doubles);
        Collections.shuffle(values);
        return Collections.unmodifiableList(values);
    }
}

