/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalSaliencyStability {
    private final Map<String, Map<Integer, SaliencyFrequencyMetadata>> map = new HashMap<String, Map<Integer, SaliencyFrequencyMetadata>>();

    public LocalSaliencyStability(Set<String> decisions) {
        for (String k : decisions) {
            this.map.put(k, new HashMap());
        }
    }

    public Collection<String> getDecisions() {
        return this.map.keySet();
    }

    public List<String> getMostFrequentPositive(String decision, int k) {
        return this.map.get(decision).get(k).getPositiveFeatureNames();
    }

    public List<String> getMostFrequentNegative(String decision, int k) {
        return this.map.get(decision).get(k).getNegativeFeatureNames();
    }

    public double getPositiveStabilityScore(String decision, int k) {
        return this.map.get(decision).get(k).getPositiveFrequencyScore();
    }

    public double getNegativeStabilityScore(String decision, int k) {
        return this.map.get(decision).get(k).getNegativeFrequencyScore();
    }

    public void add(String decision, int k, List<String> positiveFeatureNames, double positiveFrequencyScore, List<String> negativeFeatureNames, double negativeFrequencyScore) {
        if (this.map.containsKey(decision)) {
            Map<Integer, SaliencyFrequencyMetadata> integerMap = this.map.get(decision);
            integerMap.put(k, new SaliencyFrequencyMetadata(positiveFeatureNames, positiveFrequencyScore, negativeFeatureNames, negativeFrequencyScore));
        }
    }

    private static class SaliencyFrequencyMetadata {
        private final List<String> positiveFeatureNames;
        private final double positiveFrequencyScore;
        private final List<String> negativeFeatureNames;
        private final double negativeFrequencyScore;

        private SaliencyFrequencyMetadata(List<String> positiveFeatureNames, double positiveFrequencyScore, List<String> negativeFeatureNames, double negativeFrequencyScore) {
            this.positiveFeatureNames = positiveFeatureNames;
            this.positiveFrequencyScore = positiveFrequencyScore;
            this.negativeFeatureNames = negativeFeatureNames;
            this.negativeFrequencyScore = negativeFrequencyScore;
        }

        double getNegativeFrequencyScore() {
            return this.negativeFrequencyScore;
        }

        double getPositiveFrequencyScore() {
            return this.positiveFrequencyScore;
        }

        List<String> getNegativeFeatureNames() {
            return this.negativeFeatureNames;
        }

        List<String> getPositiveFeatureNames() {
            return this.positiveFeatureNames;
        }
    }
}

