/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.Arrays;
import org.kie.kogito.explainability.utils.MatrixUtils;

public class WeightedLinearRegressionResults {
    private final double[] coefficients;
    private final double intercept;
    private final double gof;
    private final double mse;

    public WeightedLinearRegressionResults(double[][] coefficients, boolean intercept, double gof, double mse) {
        if (intercept) {
            double[] rawCoeffs = MatrixUtils.getCol(coefficients, 0);
            this.coefficients = Arrays.stream(rawCoeffs, 0, rawCoeffs.length - 1).toArray();
            this.intercept = rawCoeffs[rawCoeffs.length - 1];
        } else {
            this.coefficients = MatrixUtils.getCol(coefficients, 0);
            this.intercept = 0.0;
        }
        this.gof = gof;
        this.mse = mse;
    }

    public double[] predict(double[][] x) throws IllegalArgumentException {
        if (x[0].length != this.coefficients.length) {
            throw new IllegalArgumentException(String.format("Num feature mismatch: Number of columns in x (%d)", x[0].length) + String.format(" must match number of coefficients (%d)", this.coefficients.length));
        }
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.intercept;
            for (int j = 0; j < this.coefficients.length; ++j) {
                int n = i;
                y[n] = y[n] + x[i][j] * this.coefficients[j];
            }
        }
        return y;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getGof() {
        return this.gof;
    }

    public double getMSE() {
        return this.mse;
    }
}

