/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.FeatureDomain;

public class CounterfactualEntityFactory {
    private CounterfactualEntityFactory() {
    }

    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain) {
        return CounterfactualEntityFactory.from(feature, isConstrained, featureDomain, null);
    }

    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain, FeatureDistribution featureDistribution) {
        AbstractEntity entity = null;
        if (feature.getType() == Type.NUMBER) {
            if (feature.getValue().getUnderlyingObject() instanceof Double) {
                entity = DoubleEntity.from(feature, featureDomain.getLowerBound(), featureDomain.getUpperBound(), featureDistribution, isConstrained);
            } else if (feature.getValue().getUnderlyingObject() instanceof Integer) {
                entity = IntegerEntity.from(feature, featureDomain.getLowerBound().intValue(), featureDomain.getUpperBound().intValue(), featureDistribution, isConstrained);
            }
        } else if (feature.getType() == Type.BOOLEAN) {
            entity = BooleanEntity.from(feature, isConstrained);
        } else if (feature.getType() == Type.CATEGORICAL) {
            entity = CategoricalEntity.from(feature, featureDomain.getCategories(), isConstrained);
        } else {
            throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
        }
        return entity;
    }
}

