/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.utils.WeightedLinearRegression;
import org.kie.kogito.explainability.utils.WeightedLinearRegressionResults;

class WeightedLinearRegressionTest {
    static Random random = new Random();

    WeightedLinearRegressionTest() {
    }

    @BeforeAll
    static void initRandom() {
        random.setSeed(0L);
    }

    @Test
    void testOverspecifiedNoIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}, {-20.0, 15.0, 3.3, 1.0}, {0.0, 3.0, -1.0, 2.2}, {17.0, -3.0, 0.0, 7.0}};
        double[] y = new double[]{104.0, 88.2, 130.0, 102.4, 35.2, 80.0};
        double[] sampleWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.3};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0, 6.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)wlrr.getGof(), (double)1.0E-6);
    }

    @Test
    void testOverspecifiedIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}, {-20.0, 15.0, 3.3, 1.0}, {0.0, 3.0, -1.0, 2.2}, {17.0, -3.0, 0.0, 7.0}};
        double[] y = new double[]{109.0, 93.2, 135.0, 107.4, 40.2, 85.0};
        double[] sampleWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.3};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0, 6.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)5.0, (double)wlrr.getIntercept(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)wlrr.getGof(), (double)1.0E-6);
    }

    @Test
    void testOverspecifiedWithError() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0}, {10.0, 5.0, -3.0}, {14.0, -6.6, 7.0}, {-20.0, 15.0, 3.3}, {0.0, 3.0, -1.0}, {17.0, -3.0, 0.0}};
        double[] y = new double[]{131.24777803, 72.68862812, 51.48328659, 105.24910402, 23.76140738, 41.08339528};
        double[] sampleWeights = new double[]{0.11155536, 0.2297424, 0.18834107, 0.30395088, 0.06050119, 0.10590911};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0);
        Assertions.assertTrue((wlrr.getMSE() <= 10.0 ? 1 : 0) != 0);
    }

    @Test
    void testUnderspecifiedNoIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{104.0, 88.2, 130.0};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        for (int run = 0; run < 100; ++run) {
            WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
            Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
            Assertions.assertEquals((double)1.0, (double)wlrr.getGof(), (double)1.0E-6);
        }
    }

    @Test
    void testUnderspecifiedIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2, 129.0};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        for (int run = 0; run < 100; ++run) {
            WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
            Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
            Assertions.assertEquals((double)1.0, (double)wlrr.getGof(), (double)1.0E-6);
        }
    }

    @Test
    void testOneSample() {
        double[][] x = new double[][]{{1.0, 2.0, 3.0, 4.0}};
        double[] y = new double[]{72.0};
        double[] sampleWeights = new double[]{1.0};
        Assertions.assertThrows(ArithmeticException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }

    @Test
    void testOneFeature() {
        double[][] x = new double[][]{{1.0}, {4.0}, {10.0}, {5.0}};
        double[] y = new double[]{5.0, 20.0, 50.0, 25.0};
        double[] sampleWeights = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] actualCoefs = new double[]{5.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getIntercept(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)wlrr.getGof(), (double)1.0E-6);
    }

    @Test
    void testSampleMismatch() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        Assertions.assertThrows(IllegalArgumentException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }

    @Test
    void testZeroWeights() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2};
        double[] sampleWeights = new double[]{0.0, 0.0, 0.0};
        Assertions.assertThrows(IllegalArgumentException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }
}

