/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualResult;
import org.kie.kogito.explainability.model.BasePrediction;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;

public class CounterfactualPrediction
extends BasePrediction {
    private final PredictionFeatureDomain domain;
    private final List<Boolean> constraints;
    private final DataDistribution dataDistribution;
    private final Consumer<CounterfactualResult> intermediateConsumer;

    public CounterfactualPrediction(PredictionInput input, PredictionOutput output) {
        super(input, output);
        this.domain = new PredictionFeatureDomain(Collections.emptyList());
        this.constraints = IntStream.range(0, input.getFeatures().size()).mapToObj(x -> false).collect(Collectors.toList());
        this.dataDistribution = null;
        this.intermediateConsumer = null;
    }

    public CounterfactualPrediction(PredictionInput input, PredictionOutput output, PredictionFeatureDomain domain, List<Boolean> constraints, DataDistribution dataDistribution, Consumer<CounterfactualResult> intermediateConsumer, UUID executionId) {
        super(input, output, executionId);
        this.domain = domain;
        this.constraints = constraints;
        this.dataDistribution = dataDistribution;
        this.intermediateConsumer = intermediateConsumer;
    }

    public PredictionFeatureDomain getDomain() {
        return this.domain;
    }

    public List<Boolean> getConstraints() {
        return this.constraints;
    }

    public DataDistribution getDataDistribution() {
        return this.dataDistribution;
    }

    public Consumer<CounterfactualResult> getIntermediateConsumer() {
        return this.intermediateConsumer;
    }
}

