/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.util.ArrayList;
import org.kie.kogito.explainability.local.counterfactual.CounterFactualScoreCalculator;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualSolution;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.LocalSearchAcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

public class CounterfactualConfigurationFactory {
    private static final long DEFAULT_TIME_LIMIT = 60L;
    private static final int DEFAULT_TABU_SIZE = 70;
    private static final int DEFAULT_ACCEPTED_COUNT = 5000;

    private CounterfactualConfigurationFactory() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TerminationConfig terminationConfig = new TerminationConfig();
        private int tabuSize = 70;
        private int acceptedCount = 5000;
        private long secondsSpentLimit = 60L;

        private Builder() {
        }

        public SolverConfig build() {
            SolverConfig solverConfig = new SolverConfig();
            solverConfig.withEntityClasses(new Class[]{IntegerEntity.class, DoubleEntity.class, BooleanEntity.class, CategoricalEntity.class});
            solverConfig.setSolutionClass(CounterfactualSolution.class);
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(CounterFactualScoreCalculator.class);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
            this.terminationConfig.setSecondsSpentLimit(Long.valueOf(this.secondsSpentLimit));
            solverConfig.setTerminationConfig(this.terminationConfig);
            LocalSearchAcceptorConfig acceptorConfig = new LocalSearchAcceptorConfig();
            acceptorConfig.setEntityTabuSize(Integer.valueOf(this.tabuSize));
            LocalSearchForagerConfig localSearchForagerConfig = new LocalSearchForagerConfig();
            localSearchForagerConfig.setAcceptedCountLimit(Integer.valueOf(this.acceptedCount));
            LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
            localSearchPhaseConfig.setAcceptorConfig(acceptorConfig);
            localSearchPhaseConfig.setForagerConfig(localSearchForagerConfig);
            ArrayList<LocalSearchPhaseConfig> phaseConfigs = new ArrayList<LocalSearchPhaseConfig>();
            phaseConfigs.add(localSearchPhaseConfig);
            solverConfig.setPhaseConfigList(phaseConfigs);
            return solverConfig;
        }

        public Builder withTabuSize(int size) {
            this.tabuSize = size;
            return this;
        }

        public Builder withSecondsSpentLimit(long seconds) {
            this.secondsSpentLimit = seconds;
            return this;
        }

        public Builder withAcceptedCount(int count) {
            this.acceptedCount = count;
            return this;
        }

        public Builder withTerminationConfig(TerminationConfig terminationConfig) {
            this.terminationConfig = terminationConfig;
            return this;
        }
    }
}

