/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.conf.StaticConfigBean;
import org.kie.kogito.explainability.model.PredictOutput;

@QuarkusTest
public class QuarkusExplainableResourceIT {
    @Singleton
    public static ConfigBean configBeanProducer() {
        return new StaticConfigBean("http://localhost:8081");
    }

    @Test
    void explainServiceTest() {
        String resourceId = String.format("%s:%s", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        String body = String.format("[{\"request\" : {\"Driver\": {\"Age\": 25, \"Points\": 100}, \"Violation\": {\"Type\" : \"speed\", \"Actual Speed\": 120, \"Speed Limit\": 40}},\"modelIdentifier\": {\"resourceType\": \"dmn\",\"resourceId\": \"%s\"}}]", resourceId);
        List outputs = (List)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(body).post("/predict", new Object[0])).as((TypeRef)new TypeRef<List<PredictOutput>>(){});
        Assertions.assertEquals((int)1, (int)outputs.size());
        PredictOutput output = (PredictOutput)outputs.get(0);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getResult());
        Assertions.assertNotNull((Object)output.getModelIdentifier());
        Map result = output.getResult();
        Assertions.assertTrue((boolean)result.containsKey("Should the driver be suspended?"));
        Assertions.assertEquals((Object)"Yes", result.get("Should the driver be suspended?"));
        Assertions.assertTrue((boolean)result.containsKey("Fine"));
        HashMap<String, Integer> expectedFine = new HashMap<String, Integer>();
        expectedFine.put("Points", 7);
        expectedFine.put("Amount", 1000);
        Assertions.assertEquals(expectedFine, result.get("Fine"));
    }

    @Test
    void explainServiceTestMultipleInputs() {
        String resourceId = String.format("%s:%s", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        String body = String.format("[{\"request\" : {\"Driver\": {\"Age\": 25, \"Points\": 100}, \"Violation\": {\"Type\" : \"speed\", \"Actual Speed\": 120, \"Speed Limit\": 40}},\"modelIdentifier\": {\"resourceType\": \"dmn\",\"resourceId\": \"%s\"}}, {\"request\" : {\"Driver\": {\"Age\": 25, \"Points\": 100}, \"Violation\": {\"Type\" : \"speed\", \"Actual Speed\": 120, \"Speed Limit\": 120}},\"modelIdentifier\": {\"resourceType\": \"dmn\",\"resourceId\": \"%s\"}}]", resourceId, resourceId);
        List outputs = (List)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(body).post("/predict", new Object[0])).as((TypeRef)new TypeRef<List<PredictOutput>>(){});
        Assertions.assertEquals((int)2, (int)outputs.size());
        PredictOutput output = (PredictOutput)outputs.get(1);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getResult());
        Assertions.assertNotNull((Object)output.getModelIdentifier());
        Map result = output.getResult();
        Assertions.assertTrue((boolean)result.containsKey("Should the driver be suspended?"));
        Assertions.assertEquals((Object)"No", result.get("Should the driver be suspended?"));
        Assertions.assertNull(result.get("Fine"));
    }

    @Test
    void explainServiceTestNoInputs() {
        String body = "[]";
        List outputs = (List)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(body).post("/predict", new Object[0])).as((TypeRef)new TypeRef<List<PredictOutput>>(){});
        Assertions.assertEquals((int)0, (int)outputs.size());
    }

    @Test
    void explainServiceFail() {
        String unknownResourceId = "unknown:model";
        String body = String.format("[{\"request\" : {\"Driver\": {\"Age\": 25, \"Points\": 100}, \"Violation\": {\"Type\" : \"speed\", \"Actual Speed\": 120, \"Speed Limit\": 40}},\"modelIdentifier\": {\"resourceType\": \"dmn\",\"resourceId\": \"%s\"}}, {\"request\" : {\"Driver\": {\"Age\": 25, \"Points\": 100}, \"Violation\": {\"Type\" : \"speed\", \"Actual Speed\": 120, \"Speed Limit\": 120}},\"modelIdentifier\": {\"resourceType\": \"dmn\",\"resourceId\": \"%s\"}}]", unknownResourceId, unknownResourceId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(body).post("/predict", new Object[0])).then()).statusCode(Response.Status.BAD_REQUEST.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).body(Matchers.containsString((String)("Model " + unknownResourceId + " not found.")), new Matcher[0]);
    }
}

