/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.reactivex.BackpressureStrategy;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.kie.kogito.explainability.ExplanationService;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.ExplainabilityRequest;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityMessagingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainabilityMessagingHandler.class);
    private static final URI URI_PRODUCER = URI.create("explainabilityService/ExplainabilityMessagingHandler");
    private final PublishSubject<String> eventSubject = PublishSubject.create();
    protected ExplanationService explanationService;
    protected PredictionProviderFactory predictionProviderFactory;
    @Inject
    ObjectMapper objectMapper;

    @Inject
    public ExplainabilityMessagingHandler(ExplanationService explanationService, PredictionProviderFactory predictionProviderFactory) {
        this.explanationService = explanationService;
        this.predictionProviderFactory = predictionProviderFactory;
    }

    @Incoming(value="trusty-explainability-request")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        try {
            Optional<CloudEvent> cloudEventOpt = this.decodeCloudEvent((String)message.getPayload());
            if (!cloudEventOpt.isPresent()) {
                return message.ack();
            }
            CloudEvent cloudEvent = cloudEventOpt.get();
            return this.handleCloudEvent(cloudEvent).thenAccept(x -> message.ack());
        }
        catch (Exception e) {
            LOGGER.error("Something unexpected happened during the processing of an Event. The event is discarded.", (Throwable)e);
            return message.ack();
        }
    }

    private Optional<CloudEvent> decodeCloudEvent(String payload) {
        try {
            return Optional.of(CloudEventUtils.decode((String)payload));
        }
        catch (IllegalStateException e) {
            LOGGER.error(String.format("Can't decode message to CloudEvent: %s", payload), (Throwable)e);
            return Optional.empty();
        }
    }

    private CompletionStage<Void> handleCloudEvent(CloudEvent cloudEvent) {
        ExplainabilityRequestDto requestDto;
        try {
            requestDto = (ExplainabilityRequestDto)this.objectMapper.readValue(cloudEvent.getData(), ExplainabilityRequestDto.class);
        }
        catch (IOException e) {
            LOGGER.error("Unable to deserialize CloudEvent data as ExplainabilityRequest", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
        if (requestDto == null) {
            LOGGER.error("Received CloudEvent with id {} from {} with empty data", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
            return CompletableFuture.completedFuture(null);
        }
        LOGGER.info("Received CloudEvent with id {} from {}", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
        ExplainabilityRequest request = ExplainabilityRequest.from((ExplainabilityRequestDto)requestDto);
        PredictionProvider provider = this.predictionProviderFactory.createPredictionProvider(request);
        return this.explanationService.explainAsync(request, provider).thenApply(this::sendEvent);
    }

    public Void sendEvent(ExplainabilityResultDto result) {
        LOGGER.info("Explainability service emits explainability for execution with ID {}", (Object)result.getExecutionId());
        Optional event = CloudEventUtils.build((String)result.getExecutionId(), (URI)URI_PRODUCER, (Object)result, ExplainabilityResultDto.class);
        if (event.isPresent()) {
            String payload = CloudEventUtils.encode((CloudEvent)((CloudEvent)event.get()));
            this.eventSubject.onNext((Object)payload);
        } else {
            LOGGER.warn("Ignoring empty CloudEvent");
        }
        return null;
    }

    @Outgoing(value="trusty-explainability-result")
    public Publisher<String> getEventPublisher() {
        return this.eventSubject.toFlowable(BackpressureStrategy.BUFFER);
    }
}

