/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniDelayOnItem;
import io.smallrye.mutiny.operators.UniDelayUntil;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class UniOnItemDelay<T> {
    private final Uni<T> upstream;
    private ScheduledExecutorService executor;

    public UniOnItemDelay(Uni<T> upstream, ScheduledExecutorService executor) {
        this.upstream = upstream;
        this.executor = executor == null ? Infrastructure.getDefaultWorkerPool() : executor;
    }

    public UniOnItemDelay<T> onExecutor(ScheduledExecutorService executor) {
        this.executor = ParameterValidation.nonNull(executor, "executor");
        return this;
    }

    public Uni<T> by(Duration duration) {
        return Infrastructure.onUniCreation(new UniDelayOnItem<T>(this.upstream, duration, this.executor));
    }

    public Uni<T> until(Function<? super T, ? extends Uni<?>> function) {
        return Infrastructure.onUniCreation(new UniDelayUntil<T>(this.upstream, function, this.executor));
    }
}

