/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class OpenAPIImpl
extends ExtensibleImpl<OpenAPI>
implements OpenAPI,
ModelImpl {
    private String openapi;
    private Info info;
    private ExternalDocumentation externalDocs;
    private List<Server> servers;
    private List<SecurityRequirement> security;
    private List<Tag> tags;
    private Paths paths;
    private Components components;

    @Override
    public String getOpenapi() {
        return this.openapi;
    }

    @Override
    public void setOpenapi(String openapi) {
        this.openapi = openapi;
    }

    @Override
    public Info getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(Info info) {
        this.info = info;
    }

    @Override
    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    @Override
    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    @Override
    public List<Server> getServers() {
        return ModelUtil.unmodifiableList(this.servers);
    }

    @Override
    public void setServers(List<Server> servers) {
        this.servers = ModelUtil.replace(servers, ArrayList::new);
    }

    @Override
    public OpenAPI addServer(Server server) {
        this.servers = ModelUtil.add(server, this.servers, ArrayList::new);
        return this;
    }

    @Override
    public void removeServer(Server server) {
        ModelUtil.remove(this.servers, server);
    }

    @Override
    public List<SecurityRequirement> getSecurity() {
        return ModelUtil.unmodifiableList(this.security);
    }

    @Override
    public void setSecurity(List<SecurityRequirement> security) {
        this.security = ModelUtil.replace(security, ArrayList::new);
    }

    @Override
    public OpenAPI addSecurityRequirement(SecurityRequirement securityRequirement) {
        ModelUtil.add(securityRequirement, this.security, ArrayList::new);
        return this;
    }

    @Override
    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        ModelUtil.remove(this.security, securityRequirement);
    }

    @Override
    public List<Tag> getTags() {
        return ModelUtil.unmodifiableList(this.tags);
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = ModelUtil.replace(tags, ArrayList::new);
    }

    @Override
    public OpenAPI addTag(Tag tag) {
        if (tag == null) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        if (!this.hasTag(tag.getName())) {
            this.tags.add(tag);
        }
        return this;
    }

    @Override
    public void removeTag(Tag tag) {
        ModelUtil.remove(this.tags, tag);
    }

    private boolean hasTag(String name) {
        if (this.tags == null || name == null) {
            return false;
        }
        return this.tags.stream().anyMatch(tag -> tag.getName().equals(name));
    }

    @Override
    public Paths getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(Paths paths) {
        this.paths = paths;
    }

    @Override
    public Components getComponents() {
        return this.components;
    }

    @Override
    public void setComponents(Components components) {
        this.components = components;
    }

    @Override
    public OpenAPI path(String name, PathItem path) {
        if (this.paths == null) {
            this.paths = new PathsImpl();
        }
        this.paths.addPathItem(name, path);
        return this;
    }
}

