/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

public class FeatureFactory {
    private FeatureFactory() {
    }

    public static Feature newTextFeature(String name, String text) {
        return new Feature(name, Type.TEXT, new Value<String>(text));
    }

    public static Feature newCategoricalFeature(String name, String category) {
        return new Feature(name, Type.CATEGORICAL, new Value<String>(category));
    }

    public static Feature newNumericalFeature(String name, Number number) {
        return new Feature(name, Type.NUMBER, new Value<Number>(number));
    }

    public static Feature newBooleanFeature(String name, Boolean truthValue) {
        return new Feature(name, Type.BOOLEAN, new Value<Boolean>(truthValue));
    }

    public static Feature newCurrencyFeature(String name, Currency currency) {
        return new Feature(name, Type.CURRENCY, new Value<Currency>(currency));
    }

    public static Feature newBinaryFeature(String name, ByteBuffer byteBuffer) {
        return new Feature(name, Type.BINARY, new Value<ByteBuffer>(byteBuffer));
    }

    public static Feature newURIFeature(String name, URI uri) {
        return new Feature(name, Type.URI, new Value<URI>(uri));
    }

    public static Feature newDurationFeature(String name, Duration duration) {
        return new Feature(name, Type.DURATION, new Value<Duration>(duration));
    }

    public static Feature newTimeFeature(String name, LocalTime time) {
        return new Feature(name, Type.TIME, new Value<LocalTime>(time));
    }

    public static Feature newVectorFeature(String name, double ... doubles) {
        return new Feature(name, Type.VECTOR, new Value<double[]>(doubles));
    }

    public static Feature newObjectFeature(String name, Object object) {
        return new Feature(name, Type.UNDEFINED, new Value<Object>(object));
    }

    public static Feature newCompositeFeature(String name, Map<String, Object> map) {
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FeatureFactory.parseFeatureValue(features, entry);
        }
        return FeatureFactory.newCompositeFeature(name, features);
    }

    public static Feature newCompositeFeature(String name, List<Feature> features) {
        return new Feature(name, Type.COMPOSITE, new Value<List<Feature>>(features));
    }

    private static void parseFeatureValue(List<Feature> features, Map.Entry<String, Object> entry) {
        Feature feature;
        Object value = entry.getValue();
        String featureName = entry.getKey();
        if (value instanceof Map) {
            feature = FeatureFactory.newCompositeFeature(featureName, (Map)value);
        } else if (value instanceof double[]) {
            feature = FeatureFactory.newVectorFeature(featureName, (double[])value);
        } else if (value instanceof LocalTime) {
            feature = FeatureFactory.newTimeFeature(featureName, (LocalTime)value);
        } else if (value instanceof Duration) {
            feature = FeatureFactory.newDurationFeature(featureName, (Duration)value);
        } else if (value instanceof URI) {
            feature = FeatureFactory.newURIFeature(featureName, (URI)value);
        } else if (value instanceof ByteBuffer) {
            feature = FeatureFactory.newBinaryFeature(featureName, (ByteBuffer)value);
        } else if (value instanceof Currency) {
            feature = FeatureFactory.newCurrencyFeature(featureName, (Currency)value);
        } else if (value instanceof Boolean) {
            feature = FeatureFactory.newBooleanFeature(featureName, (Boolean)value);
        } else if (value instanceof Number) {
            feature = FeatureFactory.newNumericalFeature(featureName, (Number)value);
        } else if (value instanceof String) {
            feature = FeatureFactory.newTextFeature(featureName, (String)value);
        } else if (value instanceof Feature) {
            feature = (Feature)value;
        } else if (value instanceof List) {
            try {
                List featureList = (List)value;
                feature = FeatureFactory.newCompositeFeature(featureName, featureList);
            }
            catch (ClassCastException cce) {
                feature = FeatureFactory.newObjectFeature(featureName, value);
            }
        } else {
            feature = FeatureFactory.newObjectFeature(featureName, value);
        }
        features.add(feature);
    }
}

