/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.model.FeatureImportance;

public class Saliency {
    private final List<FeatureImportance> perFeatureImportance;

    public Saliency(List<FeatureImportance> perFeatureImportance) {
        this.perFeatureImportance = perFeatureImportance;
    }

    public List<FeatureImportance> getPerFeatureImportance() {
        return this.perFeatureImportance;
    }

    public List<FeatureImportance> getTopFeatures(int k) {
        return this.perFeatureImportance.stream().sorted((f0, f1) -> Double.compare(Math.abs(f1.getScore()), Math.abs(f0.getScore()))).limit(k).collect(Collectors.toList());
    }

    public List<FeatureImportance> getPositiveFeatures(int k) {
        return this.perFeatureImportance.stream().sorted((f0, f1) -> Double.compare(Math.abs(f1.getScore()), Math.abs(f0.getScore()))).filter(f -> f.getScore() >= 0.0).limit(k).collect(Collectors.toList());
    }

    public List<FeatureImportance> getNegativeFeatures(int k) {
        return this.perFeatureImportance.stream().sorted((f0, f1) -> Double.compare(Math.abs(f1.getScore()), Math.abs(f0.getScore()))).filter(f -> f.getScore() < 0.0).limit(k).collect(Collectors.toList());
    }

    public String toString() {
        return "Saliency{perFeatureImportance=" + this.perFeatureImportance + "}";
    }
}

