/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class Value<S> {
    private final S underlyingObject;

    public Value(S underlyingObject) {
        this.underlyingObject = underlyingObject;
    }

    public String asString() {
        return ArrayUtils.toString(this.underlyingObject);
    }

    public double asNumber() {
        if (this.underlyingObject != null) {
            try {
                return this.underlyingObject instanceof Boolean ? (((Boolean)this.underlyingObject).booleanValue() ? 1.0 : 0.0) : Double.parseDouble(this.asString());
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public S getUnderlyingObject() {
        return this.underlyingObject;
    }

    public String toString() {
        return "Value{" + this.underlyingObject + "}";
    }

    public double[] asVector() {
        double[] doubles;
        if (this.underlyingObject instanceof double[]) {
            doubles = (double[])this.underlyingObject;
        } else if (this.underlyingObject instanceof String) {
            String[] tokens = ((String)this.underlyingObject).split(",?\\s+");
            int noOfWords = tokens.length;
            doubles = new double[noOfWords];
            if (Arrays.stream(tokens).allMatch(s -> s.matches("-?\\d+(\\.\\d+)?"))) {
                for (int i = 0; i < tokens.length; ++i) {
                    doubles[i] = Double.parseDouble(tokens[i]);
                }
            } else {
                Arrays.fill(doubles, 1.0);
            }
        } else {
            double v = this.asNumber();
            doubles = new double[]{v};
        }
        return doubles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Value value = (Value)o;
        return Objects.equals(this.underlyingObject, value.underlyingObject);
    }

    public int hashCode() {
        return Objects.hash(this.underlyingObject);
    }
}

