/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Saliency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LimeExplainerProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LimeExplainerProducer.class);
    private final Integer numberOfSamples;
    private final Integer numberOfPerturbations;

    public LimeExplainerProducer() {
    }

    @Inject
    public LimeExplainerProducer(@ConfigProperty(name="trusty.explainability.numberOfSamples", defaultValue="100") Integer numberOfSamples, @ConfigProperty(name="trusty.explainability.numberOfPerturbations", defaultValue="1") Integer numberOfPerturbations) {
        this.numberOfSamples = numberOfSamples;
        this.numberOfPerturbations = numberOfPerturbations;
    }

    @Produces
    public LocalExplainer<Map<String, Saliency>> produce() {
        LOG.debug("LimeExplainer created (numberOfSamples={}, numberOfPerturbations={})", (Object)this.numberOfSamples, (Object)this.numberOfPerturbations);
        return new LimeExplainer((int)this.numberOfSamples, this.numberOfPerturbations);
    }
}

