/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import io.vertx.mutiny.core.Vertx;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.RemotePredictionProvider;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.ExplainabilityRequest;

@ApplicationScoped
public class PredictionProviderFactoryImpl
implements PredictionProviderFactory {
    private final Vertx vertx;
    private final ThreadContext threadContext;
    private final ManagedExecutor managedExecutor;

    public PredictionProviderFactoryImpl() {
    }

    @Inject
    public PredictionProviderFactoryImpl(Vertx vertx, ThreadContext threadContext, ManagedExecutor managedExecutor) {
        this.vertx = vertx;
        this.threadContext = threadContext;
        this.managedExecutor = managedExecutor;
    }

    @Override
    public PredictionProvider createPredictionProvider(ExplainabilityRequest request) {
        return new RemotePredictionProvider(request, this.vertx, this.threadContext, this.managedExecutor);
    }
}

