/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

public class DataUtils {
    private DataUtils() {
    }

    public static double[] generateData(double mean, double stdDeviation, int size, Random random) {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = random.nextGaussian() * stdDeviation + mean;
        }
        double m = DataUtils.getMean(data);
        double d = DataUtils.getStdDev(data, m);
        double d1 = stdDeviation / d;
        int i = 0;
        while (i < size) {
            int n = i++;
            data[n] = data[n] * d1;
        }
        double m1 = m * stdDeviation / d;
        int i2 = 0;
        while (i2 < size) {
            int n = i2++;
            data[n] = data[n] + (mean - m1);
        }
        return data;
    }

    static double getMean(double[] data) {
        double m = 0.0;
        for (double datum : data) {
            m += datum;
        }
        return m /= (double)data.length;
    }

    static double getStdDev(double[] data, double mean) {
        double d = 0.0;
        for (double datum : data) {
            d += Math.pow(datum - mean, 2.0);
        }
        d /= (double)data.length;
        d = Math.sqrt(d);
        return d;
    }

    public static double[] generateSamples(double min, double max, int size) {
        double[] data = new double[size];
        double val = min;
        double sum = max / (double)size;
        for (int i = 0; i < size; ++i) {
            data[i] = val;
            val += sum;
        }
        return data;
    }

    public static List<Feature> doublesToFeatures(double[] inputs) {
        return DoubleStream.of(inputs).mapToObj(DataUtils::doubleToFeature).collect(Collectors.toList());
    }

    static Feature doubleToFeature(double d) {
        return FeatureFactory.newNumericalFeature(String.valueOf(d), d);
    }

    public static PredictionInput perturbFeatures(List<Feature> originalFeatures, PerturbationContext perturbationContext) {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>(originalFeatures);
        PredictionInput perturbedInput = new PredictionInput(newFeatures);
        if (!newFeatures.isEmpty()) {
            int[] indexesToBePerturbed;
            int perturbationSize = Math.min(perturbationContext.getNoOfPerturbations(), originalFeatures.size());
            for (int index : indexesToBePerturbed = perturbationContext.getRandom().ints(0, perturbedInput.getFeatures().size()).distinct().limit(perturbationSize).toArray()) {
                Feature feature = perturbedInput.getFeatures().get(index);
                Feature perturbedFeature = FeatureFactory.copyOf(feature, feature.getType().perturb(feature.getValue(), perturbationContext));
                perturbedInput.getFeatures().set(index, perturbedFeature);
            }
        }
        return perturbedInput;
    }

    public static List<Feature> dropFeature(List<Feature> features, Feature target) {
        String name = target.getName();
        Value value = target.getValue();
        Feature droppedFeature = null;
        block0: for (Feature feature : features) {
            if (!name.equals(feature.getName())) continue;
            if (value.equals(feature.getValue())) {
                droppedFeature = FeatureFactory.copyOf(feature, feature.getType().drop(value));
                break;
            }
            List<Feature> linearizedFeatures = DataUtils.getLinearizedFeatures(List.of(feature));
            int i = 0;
            for (Feature linearizedFeature : linearizedFeatures) {
                if (value.equals(linearizedFeature.getValue())) {
                    Feature e = linearizedFeatures.get(i);
                    linearizedFeatures.set(i, FeatureFactory.copyOf(e, e.getType().drop(value)));
                    droppedFeature = FeatureFactory.newCompositeFeature(name, linearizedFeatures);
                    break block0;
                }
                ++i;
            }
        }
        List<Feature> copy = List.copyOf(features);
        if (droppedFeature != null) {
            Feature finalDroppedFeature = droppedFeature;
            copy = copy.stream().map(f -> f.getName().equals(finalDroppedFeature.getName()) ? finalDroppedFeature : f).collect(Collectors.toList());
        }
        return copy;
    }

    public static double hammingDistance(double[] x, double[] y) {
        if (x.length != y.length) {
            return Double.NaN;
        }
        double h = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            h += 1.0;
        }
        return h;
    }

    public static double hammingDistance(String x, String y) {
        if (x.length() != y.length()) {
            return Double.NaN;
        }
        double h = 0.0;
        for (int i = 0; i < x.length(); ++i) {
            if (x.charAt(i) == y.charAt(i)) continue;
            h += 1.0;
        }
        return h;
    }

    public static double euclideanDistance(double[] x, double[] y) {
        if (x.length != y.length) {
            return Double.NaN;
        }
        double e = 0.0;
        for (int i = 0; i < x.length; ++i) {
            e += Math.pow(x[i] - y[i], 2.0);
        }
        return Math.sqrt(e);
    }

    public static double gaussianKernel(double x, double mu, double sigma) {
        return Math.exp(-Math.pow((x - mu) / sigma, 2.0) / 2.0) / (sigma * Math.sqrt(Math.PI * 2));
    }

    public static double exponentialSmoothingKernel(double x, double width) {
        return Math.sqrt(Math.exp(-Math.pow(x, 2.0) / Math.pow(width, 2.0)));
    }

    public static FeatureDistribution getFeatureDistribution(double[] doubles) {
        double min = DoubleStream.of(doubles).min().orElse(0.0);
        double max = DoubleStream.of(doubles).max().orElse(0.0);
        double mean = DataUtils.getMean(doubles);
        double stdDev = DataUtils.getStdDev(doubles, mean);
        return new FeatureDistribution(min, max, mean, stdDev);
    }

    public static DataDistribution generateRandomDataDistribution(int noOfFeatures, int distributionSize, Random random) {
        LinkedList<FeatureDistribution> featureDistributions = new LinkedList<FeatureDistribution>();
        for (int i = 0; i < noOfFeatures; ++i) {
            double[] doubles = DataUtils.generateData(random.nextDouble(), random.nextDouble(), distributionSize, random);
            FeatureDistribution featureDistribution = DataUtils.getFeatureDistribution(doubles);
            featureDistributions.add(featureDistribution);
        }
        return new DataDistribution(featureDistributions);
    }

    public static List<PredictionInput> linearizeInputs(List<PredictionInput> predictionInputs) {
        LinkedList<PredictionInput> newInputs = new LinkedList<PredictionInput>();
        for (PredictionInput predictionInput : predictionInputs) {
            List<Feature> originalFeatures = predictionInput.getFeatures();
            List<Feature> flattenedFeatures = DataUtils.getLinearizedFeatures(originalFeatures);
            newInputs.add(new PredictionInput(flattenedFeatures));
        }
        return newInputs;
    }

    public static List<Feature> getLinearizedFeatures(List<Feature> originalFeatures) {
        LinkedList<Feature> flattenedFeatures = new LinkedList<Feature>();
        for (Feature f : originalFeatures) {
            DataUtils.linearizeFeature(flattenedFeatures, f);
        }
        return flattenedFeatures;
    }

    private static void linearizeFeature(List<Feature> flattenedFeatures, Feature f) {
        if (Type.UNDEFINED.equals((Object)f.getType())) {
            if (f.getValue().getUnderlyingObject() instanceof Feature) {
                DataUtils.linearizeFeature(flattenedFeatures, (Feature)f.getValue().getUnderlyingObject());
            } else {
                flattenedFeatures.add(f);
            }
        } else if (Type.COMPOSITE.equals((Object)f.getType())) {
            List features = (List)f.getValue().getUnderlyingObject();
            for (Feature feature : features) {
                DataUtils.linearizeFeature(flattenedFeatures, feature);
            }
        } else {
            flattenedFeatures.add(f);
        }
    }
}

