/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;

@QuarkusTest
public class ExplainabilityApiV1Test {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testEndpointWithRequest() throws JsonProcessingException {
        String executionId = "test";
        String serviceUrl = "http://localhost:8080";
        ModelIdentifierDto modelIdentifierDto = new ModelIdentifierDto("dmn", "namespace:name");
        String body = MAPPER.writeValueAsString((Object)new ExplainabilityRequestDto(executionId, serviceUrl, modelIdentifierDto, Collections.emptyMap(), Collections.emptyMap()));
        ExplainabilityResultDto result = (ExplainabilityResultDto)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/v1/explain", new Object[0])).as(ExplainabilityResultDto.class);
        Assertions.assertEquals((Object)executionId, (Object)result.getExecutionId());
    }
}

