/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.AuthenticationCompletionException;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String SESSION_COOKIE_NAME = "q_session";
    private static final String POST_LOGOUT_COOKIE_NAME = "q_post_logout";
    private static final String COOKIE_DELIM = "|";
    private static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken, RoutingContext context) {
        IdTokenCredential idTokenCredential = securityIdentity.getCredential(IdTokenCredential.class);
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredential(idTokenCredential).addCredential(new AccessTokenCredential(accessToken, refreshTokenCredential, context)).addCredential(refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker(new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager, DefaultTenantConfigResolver resolver) {
        io.vertx.core.http.Cookie sessionCookie = context.request().getCookie(CodeAuthenticationMechanism.getSessionCookieName(resolver.resolve(context, false)));
        if (sessionCookie != null) {
            String[] tokens = COOKIE_PATTERN.split(sessionCookie.getValue());
            final String idToken = tokens[0];
            final String accessToken = tokens[1];
            final String refreshToken = tokens[2];
            final TenantConfigContext configContext = resolver.resolve(context, true);
            context.put("access_token", accessToken);
            return this.authenticate(identityProviderManager, new IdTokenCredential(idToken, context)).map(new Function<SecurityIdentity, SecurityIdentity>(){

                @Override
                public SecurityIdentity apply(SecurityIdentity identity) {
                    if (CodeAuthenticationMechanism.this.isLogout(context, configContext)) {
                        throw CodeAuthenticationMechanism.this.redirectToLogoutEndpoint(context, configContext, idToken);
                    }
                    return CodeAuthenticationMechanism.augmentIdentity(identity, accessToken, refreshToken, context);
                }
            }).on().failure().recoverWithItem(new Function<Throwable, SecurityIdentity>(){

                @Override
                public SecurityIdentity apply(Throwable throwable) {
                    if (throwable instanceof AuthenticationRedirectException) {
                        throw (AuthenticationRedirectException)AuthenticationRedirectException.class.cast(throwable);
                    }
                    SecurityIdentity identity = null;
                    if (!(throwable instanceof TokenAutoRefreshException)) {
                        Throwable cause = throwable.getCause();
                        if (cause != null && !"expired token".equalsIgnoreCase(cause.getMessage())) {
                            LOG.debugf("Authentication failure: %s", (Object)cause);
                            throw new AuthenticationCompletionException(cause);
                        }
                        if (!configContext.oidcConfig.token.refreshExpired) {
                            LOG.debug("Token has expired, token refresh is not allowed");
                            throw new AuthenticationCompletionException(cause);
                        }
                        LOG.debug("Token has expired, trying to refresh it");
                        identity = CodeAuthenticationMechanism.this.trySilentRefresh(configContext, refreshToken, context, identityProviderManager);
                        if (identity == null) {
                            LOG.debug("SecurityIdentity is null after a token refresh");
                            throw new AuthenticationCompletionException();
                        }
                    } else {
                        identity = CodeAuthenticationMechanism.this.trySilentRefresh(configContext, refreshToken, context, identityProviderManager);
                        if (identity == null) {
                            LOG.debug("ID token can no longer be refreshed, using the current SecurityIdentity");
                            identity = ((TokenAutoRefreshException)throwable).getSecurityIdentity();
                        }
                    }
                    return identity;
                }
            });
        }
        context.put("new_authentication", Boolean.TRUE);
        return this.performCodeFlow(identityProviderManager, context, resolver);
    }

    private boolean isXHR(RoutingContext context) {
        return "XMLHttpRequest".equals(context.request().getHeader("X-Requested-With"));
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isXHR(context) ? configContext.oidcConfig.authentication.xhrAutoRedirect : true;
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context, DefaultTenantConfigResolver resolver) {
        TenantConfigContext configContext = resolver.resolve(context, true);
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext));
        if (!this.shouldAutoRedirect(configContext, context)) {
            return Uni.createFrom().item(new ChallengeData(499, "WWW-Authenticate", "OIDC"));
        }
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
        params.put("scopes", new JsonArray(scopes));
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext), redirectPath);
        LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        params.put("state", this.generateCodeFlowState(context, configContext, redirectPath));
        if (configContext.oidcConfig.authentication.getExtraParams() != null) {
            for (Map.Entry<String, String> entry : configContext.oidcConfig.authentication.getExtraParams().entrySet()) {
                params.put(entry.getKey(), entry.getValue());
            }
        }
        return Uni.createFrom().item(new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, configContext.auth.authorizeURL(params)));
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, DefaultTenantConfigResolver resolver) {
        final JsonObject params = new JsonObject();
        String code = context.request().getParam("code");
        if (code == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        final TenantConfigContext configContext = resolver.resolve(context, true);
        Cookie stateCookie = context.getCookie(CodeAuthenticationMechanism.getStateCookieName(configContext));
        String userQuery = null;
        if (stateCookie != null) {
            String[] pair;
            List<String> values = context.queryParam("state");
            if (values.size() != 1) {
                LOG.debug("State parameter can not be empty or multi-valued");
                return Uni.createFrom().failure(new AuthenticationCompletionException());
            }
            if (!stateCookie.getValue().startsWith(values.get(0))) {
                LOG.debug("State cookie value does not match the state query parameter value");
                return Uni.createFrom().failure(new AuthenticationCompletionException());
            }
            if (context.queryParam("pathChecked").isEmpty()) {
                pair = COOKIE_PATTERN.split(stateCookie.getValue());
                if (pair.length == 2) {
                    String extraPath = pair[1];
                    int userQueryIndex = extraPath.indexOf("?");
                    if (userQueryIndex != 0) {
                        if (userQueryIndex > 0) {
                            extraPath = extraPath.substring(0, userQueryIndex);
                        }
                        String extraQuery = "?pathChecked=true";
                        if (context.request().query() != null) {
                            extraQuery = extraQuery + "&" + context.request().query();
                        }
                        String localRedirectUri = this.buildUri(context, this.isForceHttps(configContext), extraPath + extraQuery);
                        LOG.debugf("Local redirect URI: %s", (Object)localRedirectUri);
                        return Uni.createFrom().failure(new AuthenticationRedirectException(localRedirectUri));
                    }
                    if (userQueryIndex + 1 < extraPath.length()) {
                        userQuery = extraPath.substring(userQueryIndex + 1);
                    }
                }
                this.removeCookie(context, configContext, CodeAuthenticationMechanism.getStateCookieName(configContext));
            } else {
                int userQueryIndex;
                pair = COOKIE_PATTERN.split(stateCookie.getValue());
                if (pair.length == 2 && (userQueryIndex = pair[1].indexOf("?")) >= 0 && userQueryIndex + 1 < pair[1].length()) {
                    userQuery = pair[1].substring(userQueryIndex + 1);
                }
                this.removeCookie(context, configContext, CodeAuthenticationMechanism.getStateCookieName(configContext));
            }
        } else {
            LOG.debug("The state cookie is missing after a redirect from IDP");
            return Uni.createFrom().failure(new AuthenticationCompletionException());
        }
        params.put("code", code);
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        OidcTenantConfig.Credentials creds = configContext.oidcConfig.getCredentials();
        if (creds.clientSecret.value.isPresent() && OidcTenantConfig.Credentials.Secret.Method.POST == creds.clientSecret.method.orElse(null)) {
            params.put("client_secret", creds.clientSecret.value.get());
        } else if (creds.jwt.secret.isPresent()) {
            params.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            params.put("client_assertion", this.signJwtWithClientSecret(configContext.oidcConfig));
        }
        final String finalUserQuery = userQuery;
        return Uni.createFrom().emitter(new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                configContext.auth.authenticate(params, userAsyncResult -> {
                    if (userAsyncResult.failed()) {
                        if (userAsyncResult.cause() != null) {
                            LOG.debugf("Exception during the code to token exchange: %s", (Object)userAsyncResult.cause().getMessage());
                        }
                        uniEmitter.fail(new AuthenticationCompletionException(userAsyncResult.cause()));
                    } else {
                        final AccessToken result = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                        context.put("access_token", result.opaqueAccessToken());
                        CodeAuthenticationMechanism.this.authenticate(identityProviderManager, new IdTokenCredential(result.opaqueIdToken(), context)).subscribe().with(new Consumer<SecurityIdentity>(){

                            @Override
                            public void accept(SecurityIdentity identity) {
                                if (!result.idToken().containsKey("exp") || !result.idToken().containsKey("iat")) {
                                    LOG.debug("ID Token is required to contain 'exp' and 'iat' claims");
                                    uniEmitter.fail(new AuthenticationCompletionException());
                                }
                                CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, result, result.opaqueRefreshToken(), identity);
                                if (configContext.oidcConfig.authentication.isRemoveRedirectParameters() && context.request().query() != null) {
                                    String finalRedirectUri = CodeAuthenticationMechanism.this.buildUriWithoutQueryParams(context);
                                    if (finalUserQuery != null) {
                                        finalRedirectUri = finalRedirectUri + "?" + finalUserQuery;
                                    }
                                    LOG.debugf("Final redirect URI: %s", (Object)finalRedirectUri);
                                    uniEmitter.fail(new AuthenticationRedirectException(finalRedirectUri));
                                } else {
                                    uniEmitter.complete(CodeAuthenticationMechanism.augmentIdentity(identity, result.opaqueAccessToken(), result.opaqueRefreshToken(), context));
                                }
                            }
                        }, new Consumer<Throwable>(){

                            @Override
                            public void accept(Throwable throwable) {
                                uniEmitter.fail(throwable);
                            }
                        });
                    }
                });
            }
        });
    }

    private String signJwtWithClientSecret(OidcTenantConfig cfg) {
        byte[] keyBytes = cfg.credentials.jwt.secret.get().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HMACSHA256");
        long iat = System.currentTimeMillis() / 1000L;
        long exp = iat + (long)cfg.credentials.jwt.lifespan;
        return Jwt.claims().issuer(cfg.clientId.get()).subject(cfg.clientId.get()).audience(cfg.authServerUrl.get()).issuedAt(iat).expiresAt(exp).sign(key);
    }

    private void processSuccessfulAuthentication(RoutingContext context, TenantConfigContext configContext, AccessToken result, String refreshToken, SecurityIdentity securityIdentity) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext));
        String cookieValue = result.opaqueIdToken() + COOKIE_DELIM + result.opaqueAccessToken() + COOKIE_DELIM + refreshToken;
        long maxAge = result.idToken().getLong("exp") - result.idToken().getLong("iat");
        if (configContext.oidcConfig.token.lifespanGrace.isPresent()) {
            maxAge += (long)configContext.oidcConfig.token.lifespanGrace.getAsInt();
        }
        if (configContext.oidcConfig.token.refreshExpired) {
            maxAge += configContext.oidcConfig.authentication.sessionAgeExtension.getSeconds();
        }
        this.createCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext), cookieValue, maxAge);
    }

    private String getRedirectPath(TenantConfigContext configContext, RoutingContext context) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath) {
        String uuid;
        String cookieValue = uuid = UUID.randomUUID().toString();
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        if (auth.isRestorePathAfterRedirect()) {
            String requestPath;
            String string = requestPath = !redirectPath.equals(context.request().path()) ? context.request().path() : "";
            if (context.request().query() != null) {
                requestPath = requestPath + "?" + context.request().query();
            }
            if (!requestPath.isEmpty()) {
                cookieValue = cookieValue + COOKIE_DELIM + requestPath;
            }
        }
        this.createCookie(context, configContext, CodeAuthenticationMechanism.getStateCookieName(configContext), cookieValue, 1800L);
        return uuid;
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext));
        return this.createCookie(context, configContext, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext), UUID.randomUUID().toString(), 1800L).getValue();
    }

    private CookieImpl createCookie(RoutingContext context, TenantConfigContext configContext, String name, String value, long maxAge) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(context.request().isSSL());
        cookie.setMaxAge(maxAge);
        LOG.debugf(name + " cookie 'max-age' parameter is set to %d", maxAge);
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        if (auth.cookiePath.isPresent()) {
            cookie.setPath(auth.getCookiePath().get());
        }
        context.response().addCookie(cookie);
        return cookie;
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        String scheme = forceHttps ? "https" : context.request().scheme();
        return scheme + "://" + URI.create(context.request().absoluteURI()).getAuthority() + path;
    }

    private String buildUriWithoutQueryParams(RoutingContext context) {
        URI absoluteUri = URI.create(context.request().absoluteURI());
        return context.request().scheme() + "://" + absoluteUri.getAuthority() + absoluteUri.getRawPath();
    }

    private void removeCookie(RoutingContext context, TenantConfigContext configContext, String cookieName) {
        ServerCookie cookie = (ServerCookie)context.cookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setValue("");
            cookie.setMaxAge(0L);
            OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
            if (auth.cookiePath.isPresent()) {
                cookie.setPath(auth.cookiePath.get());
            }
        }
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext) {
        Optional<String> logoutPath = configContext.oidcConfig.logout.path;
        if (logoutPath.isPresent()) {
            return context.request().absoluteURI().equals(this.buildUri(context, false, logoutPath.get()));
        }
        return false;
    }

    private SecurityIdentity trySilentRefresh(final TenantConfigContext configContext, final String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager) {
        Uni<? super SecurityIdentity> cf = Uni.createFrom().emitter(new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> emitter) {
                final OAuth2TokenImpl token = new OAuth2TokenImpl(configContext.auth, new JsonObject());
                token.principal().put("refresh_token", refreshToken);
                token.refresh((Handler)new Handler<AsyncResult<Void>>(){

                    @Override
                    public void handle(AsyncResult<Void> result) {
                        if (result.succeeded()) {
                            context.put("access_token", token.opaqueAccessToken());
                            CodeAuthenticationMechanism.this.authenticate(identityProviderManager, new IdTokenCredential(token.opaqueIdToken(), context)).subscribe().with(new Consumer<SecurityIdentity>(){

                                @Override
                                public void accept(SecurityIdentity identity) {
                                    String refresh = token.opaqueRefreshToken() != null ? token.opaqueRefreshToken() : refreshToken;
                                    CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, token, refresh, identity);
                                    emitter.complete(CodeAuthenticationMechanism.augmentIdentity(identity, token.opaqueAccessToken(), token.opaqueRefreshToken(), context));
                                }
                            }, new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    emitter.fail(throwable);
                                }
                            });
                        } else {
                            emitter.fail(new AuthenticationFailedException(result.cause()));
                        }
                    }
                });
            }
        });
        return cf.await().indefinitely();
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.oidcConfig.getEndSessionPath().orElse(((OAuth2AuthProviderImpl)OAuth2AuthProviderImpl.class.cast(configContext.auth)).getConfig().getLogoutPath());
        StringBuilder logoutUri = new StringBuilder(logoutPath).append("?").append("id_token_hint=").append(idToken);
        if (configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append("&post_logout_redirect_uri=").append(this.buildUri(context, this.isForceHttps(configContext), configContext.oidcConfig.logout.postLogoutPath.get()));
            logoutUri.append("&state=").append(this.generatePostLogoutState(context, configContext));
        }
        return logoutUri.toString();
    }

    private boolean isForceHttps(TenantConfigContext configContext) {
        return configContext.oidcConfig.authentication.forceRedirectHttpsScheme;
    }

    private AuthenticationRedirectException redirectToLogoutEndpoint(RoutingContext context, TenantConfigContext configContext, String idToken) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext));
        return new AuthenticationRedirectException(this.buildLogoutRedirectUri(configContext, idToken, context));
    }

    private static String getSessionCookieName(TenantConfigContext configContext) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(configContext);
        return SESSION_COOKIE_NAME + cookieSuffix;
    }

    private static String getStateCookieName(TenantConfigContext configContext) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(configContext);
        return STATE_COOKIE_NAME + cookieSuffix;
    }

    private static String getPostLogoutCookieName(TenantConfigContext configContext) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(configContext);
        return POST_LOGOUT_COOKIE_NAME + cookieSuffix;
    }

    private static String getCookieSuffix(TenantConfigContext configContext) {
        return !"Default".equals(configContext.oidcConfig.tenantId.get()) ? "_" + configContext.oidcConfig.tenantId.get() : "";
    }
}

