/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.type.TypeNameTranslator;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;

public class ModuleInfo {
    private final String packageName;
    private final String name;
    private final String groupPackage;
    private static final BiFunction<Elements, String, Set<PackageElement>> getPackageElementJava8;
    private static final BiFunction<Elements, String, Set<PackageElement>> getPackageElement;

    public ModuleInfo(String packageName, String name, String groupPackage) {
        this.packageName = packageName;
        this.name = name;
        this.groupPackage = groupPackage;
    }

    public static ModuleInfo resolve(Elements elementUtils, PackageElement pkgElt) {
        String pkgQN = pkgElt.getQualifiedName().toString();
        while (true) {
            ModuleGen annotation;
            if (pkgElt != null && (annotation = pkgElt.getAnnotation(ModuleGen.class)) != null) {
                return new ModuleInfo(pkgElt.getQualifiedName().toString(), annotation.name(), annotation.groupPackage());
            }
            int pos = pkgQN.lastIndexOf(46);
            if (pos == -1) break;
            Set<PackageElement> pkgElts = getPackageElement.apply(elementUtils, pkgQN = pkgQN.substring(0, pos));
            pkgElt = pkgElts.isEmpty() ? null : pkgElts.iterator().next();
        }
        return null;
    }

    public String getGroupPackage() {
        return this.groupPackage;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String translatePackageName(String lang) {
        return this.translateQualifiedName(this.packageName, lang);
    }

    public String translateQualifiedName(String qualifiedName, String lang) {
        return TypeNameTranslator.hierarchical(lang).translate(this, qualifiedName);
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.KEBAB.parse(this.name));
    }

    static {
        BiFunction<Elements, String, Set<PackageElement>> result = getPackageElementJava8 = (elts, fqn) -> {
            PackageElement elt = elts.getPackageElement((CharSequence)fqn);
            return elt != null ? Collections.singleton(elt) : Collections.emptySet();
        };
        try {
            Method method = Elements.class.getDeclaredMethod("getAllPackageElements", CharSequence.class);
            result = (elts, fqn) -> {
                try {
                    return (Set)method.invoke(elts, fqn);
                }
                catch (Exception e) {
                    return getPackageElementJava8.apply((Elements)elts, (String)fqn);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getPackageElement = result;
    }
}

