/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

public class FeatureFactory {
    private FeatureFactory() {
    }

    public static Feature newTextFeature(String name, String text) {
        return new Feature(name, Type.TEXT, new Value<String>(text));
    }

    public static Feature newFulltextFeature(String name, String text, Function<String, List<String>> tokenizer) {
        List<String> tokens = tokenizer.apply(text);
        ArrayList<Feature> tokenFeatures = new ArrayList<Feature>(tokens.size());
        for (String token : tokens) {
            tokenFeatures.add(FeatureFactory.newTextFeature(name, token));
        }
        return FeatureFactory.newCompositeFeature(name, tokenFeatures);
    }

    public static Feature newFulltextFeature(String name, String text) {
        return FeatureFactory.newFulltextFeature(name, text, s -> Arrays.asList(s.split(" ")));
    }

    public static Feature newCategoricalFeature(String name, String category) {
        return new Feature(name, Type.CATEGORICAL, new Value<String>(category));
    }

    public static Feature newNumericalFeature(String name, Number number) {
        return new Feature(name, Type.NUMBER, new Value<Number>(number));
    }

    public static Feature newBooleanFeature(String name, Boolean truthValue) {
        return new Feature(name, Type.BOOLEAN, new Value<Boolean>(truthValue));
    }

    public static Feature newCurrencyFeature(String name, Currency currency) {
        return new Feature(name, Type.CURRENCY, new Value<Currency>(currency));
    }

    public static Feature newBinaryFeature(String name, ByteBuffer byteBuffer) {
        return new Feature(name, Type.BINARY, new Value<ByteBuffer>(byteBuffer));
    }

    public static Feature newURIFeature(String name, URI uri) {
        return new Feature(name, Type.URI, new Value<URI>(uri));
    }

    public static Feature newDurationFeature(String name, Duration duration) {
        return new Feature(name, Type.DURATION, new Value<Duration>(duration));
    }

    public static Feature newTimeFeature(String name, LocalTime time) {
        return new Feature(name, Type.TIME, new Value<LocalTime>(time));
    }

    public static Feature newVectorFeature(String name, double ... doubles) {
        return new Feature(name, Type.VECTOR, new Value<double[]>(doubles));
    }

    public static Feature newObjectFeature(String name, Object object) {
        return new Feature(name, Type.UNDEFINED, new Value<Object>(object));
    }

    public static Feature newCompositeFeature(String name, Map<String, Object> map) {
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            features.add(FeatureFactory.parseFeatureValue(entry.getKey(), entry.getValue()));
        }
        return FeatureFactory.newCompositeFeature(name, features);
    }

    public static Feature newCompositeFeature(String name, List<Feature> features) {
        return new Feature(name, Type.COMPOSITE, new Value<List<Feature>>(features));
    }

    private static Feature parseFeatureValue(String featureName, Object value) {
        if (value instanceof Map) {
            return FeatureFactory.newCompositeFeature(featureName, (Map)value);
        }
        if (value instanceof double[]) {
            return FeatureFactory.newVectorFeature(featureName, (double[])value);
        }
        if (value instanceof LocalTime) {
            return FeatureFactory.newTimeFeature(featureName, (LocalTime)value);
        }
        if (value instanceof Duration) {
            return FeatureFactory.newDurationFeature(featureName, (Duration)value);
        }
        if (value instanceof URI) {
            return FeatureFactory.newURIFeature(featureName, (URI)value);
        }
        if (value instanceof ByteBuffer) {
            return FeatureFactory.newBinaryFeature(featureName, (ByteBuffer)value);
        }
        if (value instanceof Currency) {
            return FeatureFactory.newCurrencyFeature(featureName, (Currency)value);
        }
        if (value instanceof Boolean) {
            return FeatureFactory.newBooleanFeature(featureName, (Boolean)value);
        }
        if (value instanceof Number) {
            return FeatureFactory.newNumericalFeature(featureName, (Number)value);
        }
        if (value instanceof String) {
            return FeatureFactory.newTextFeature(featureName, (String)value);
        }
        if (value instanceof Feature) {
            return (Feature)value;
        }
        if (value instanceof List) {
            return FeatureFactory.parseList(featureName, (List)value);
        }
        return FeatureFactory.newObjectFeature(featureName, value);
    }

    private static Feature parseList(String featureName, List<?> value) {
        if (!value.isEmpty()) {
            if (value.get(0) instanceof Feature) {
                return FeatureFactory.newCompositeFeature(featureName, value);
            }
            List<Feature> fs = IntStream.range(0, value.size()).mapToObj(i -> FeatureFactory.parseFeatureValue(featureName + "_" + i, value.get(i))).collect(Collectors.toList());
            return FeatureFactory.newCompositeFeature(featureName, fs);
        }
        return FeatureFactory.newCompositeFeature(featureName, Collections.emptyList());
    }

    public static Feature copyOf(Feature feature, Value<?> value) {
        return new Feature(feature.getName(), feature.getType(), value);
    }
}

