/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public enum Type {
    TEXT("text"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<String>("");
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            return new Value<String>("");
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 1.encodeEquals(target, values);
        }
    }
    ,
    CATEGORICAL("categorical"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<String>("");
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            String category = value.asString();
            category = !"0".equals(category) ? "0" : "1";
            return new Value<String>(category);
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 2.encodeEquals(target, values);
        }
    }
    ,
    BINARY("binary"){

        @Override
        public Value<?> drop(Value<?> value) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            return new Value<ByteBuffer>(byteBuffer);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            return new Value<ByteBuffer>(byteBuffer);
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 3.encodeEquals(target, values);
        }
    }
    ,
    NUMBER("number"){
        private static final double CLUSTER_THRESHOLD = 0.001;

        @Override
        public Value<?> drop(Value<?> value) {
            value = value.asNumber() == 0.0 ? new Value<Double>(Double.NaN) : new Value<Double>(0.0);
            return value;
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            double originalFeatureValue = value.asNumber();
            boolean intValue = originalFeatureValue % 1.0 == 0.0;
            double normalDistributionSample = perturbationContext.getRandom().nextGaussian();
            if (originalFeatureValue != 0.0) {
                normalDistributionSample = normalDistributionSample * originalFeatureValue + originalFeatureValue;
            }
            if (intValue && (normalDistributionSample = (double)((int)normalDistributionSample)) == originalFeatureValue) {
                normalDistributionSample = (double)((int)normalDistributionSample) * 10.0;
            }
            return new Value<Double>(normalDistributionSample);
        }

        /*
         * Exception decompiling
         */
        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<Object>(null);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            return new Value<Boolean>(!Boolean.parseBoolean(value.asString()));
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 5.encodeEquals(target, values);
        }
    }
    ,
    URI("uri"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<URI>(java.net.URI.create(""));
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            return new Value<URI>(java.net.URI.create(""));
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 6.encodeEquals(target, values);
        }
    }
    ,
    TIME("time"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<Object>(null);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            LocalTime featureValue;
            try {
                featureValue = LocalTime.parse(value.asString());
            }
            catch (DateTimeException dateTimeException) {
                featureValue = LocalTime.now();
            }
            return new Value<LocalTime>(featureValue.minusHours(1L + (long)perturbationContext.getRandom().nextInt(23)));
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 7.encodeEquals(target, values);
        }
    }
    ,
    DURATION("duration"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<Object>(null);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            return new Value<Duration>(Duration.of(0L, ChronoUnit.SECONDS));
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 8.encodeEquals(target, values);
        }
    }
    ,
    VECTOR("vector"){

        @Override
        public Value<?> drop(Value<?> value) {
            double[] values = value.asVector();
            if (values.length > 0) {
                Arrays.fill(values, 0.0);
            }
            return new Value<double[]>(values);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            double[] vector = value.asVector();
            double[] values = Arrays.copyOf(vector, vector.length);
            if (values.length > 1) {
                int idx = perturbationContext.getRandom().nextInt(values.length);
                if (values[idx] != 0.0) {
                    values[idx] = 0.0;
                } else {
                    int n = idx;
                    values[n] = values[n] - 1.0;
                }
            }
            return new Value<double[]>(values);
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 9.encodeEquals(target, values);
        }
    }
    ,
    UNDEFINED("undefined"){

        @Override
        public Value<?> drop(Value<?> value) {
            if (value.getUnderlyingObject() instanceof Feature) {
                Feature underlyingObject = (Feature)value.getUnderlyingObject();
                value = new Value<Feature>(FeatureFactory.copyOf(underlyingObject, underlyingObject.getType().drop(underlyingObject.getValue())));
            } else {
                value = new Value<Object>(null);
            }
            return value;
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            if (value.getUnderlyingObject() instanceof Feature) {
                Feature underlyingObject = (Feature)value.getUnderlyingObject();
                Type type = underlyingObject.getType();
                Value<?> perturbedValue = type.perturb(underlyingObject.getValue(), perturbationContext);
                value = new Value<Feature>(FeatureFactory.copyOf(underlyingObject, perturbedValue));
            } else {
                value = new Value<Object>(null);
            }
            return value;
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 10.encodeEquals(target, values);
        }
    }
    ,
    COMPOSITE("composite"){

        @Override
        public Value<?> drop(Value<?> value) {
            List<Feature> composite = this.getFeatures(value);
            ArrayList<Feature> newFeatures = new ArrayList<Feature>(composite.size());
            for (Feature f : composite) {
                newFeatures.add(FeatureFactory.copyOf(f, f.getType().drop(f.getValue())));
            }
            return new Value(newFeatures);
        }

        private List<Feature> getFeatures(Value<?> value) {
            LinkedList<Feature> features;
            try {
                features = (LinkedList<Feature>)value.getUnderlyingObject();
            }
            catch (ClassCastException cce) {
                features = new LinkedList<Feature>();
            }
            return features;
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            List<Feature> composite = this.getFeatures(value);
            List<Feature> newList = DataUtils.perturbFeatures(composite, perturbationContext);
            return new Value<List<Feature>>(newList);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            List<Feature> composite = this.getFeatures(target);
            int i = 0;
            LinkedList<Object> multiColumns = new LinkedList<Object>();
            for (Feature f : composite) {
                int finalI = i++;
                List<double[]> subColumn = f.getType().encode(f.getValue(), (Value[])Arrays.stream(values).map(v -> (List)v.getUnderlyingObject()).map(l -> ((Feature)l.get(finalI)).getValue()).toArray(Value[]::new));
                multiColumns.add(subColumn);
            }
            LinkedList<double[]> result = new LinkedList<double[]>();
            for (int j = 0; j < 11.values().length; ++j) {
                void var10_12;
                LinkedList<Double> vector = new LinkedList<Double>();
                for (List list : multiColumns) {
                    double[] doubles = (double[])list.get(i);
                    vector.addAll(Arrays.asList(ArrayUtils.toObject(doubles)));
                }
                double[] doubles = new double[vector.size()];
                boolean bl = false;
                while (var10_12 < doubles.length) {
                    doubles[var10_12] = (Double)vector.get((int)var10_12);
                    ++var10_12;
                }
                result.add(doubles);
            }
            return result;
        }
    }
    ,
    CURRENCY("currency"){

        @Override
        public Value<?> drop(Value<?> value) {
            return new Value<Object>(null);
        }

        @Override
        public Value<?> perturb(Value<?> value, PerturbationContext perturbationContext) {
            return new Value<Currency>(Currency.getInstance(Locale.getDefault()));
        }

        @Override
        public List<double[]> encode(Value<?> target, Value<?> ... values) {
            return 12.encodeEquals(target, values);
        }
    };

    private final String value;

    static List<double[]> encodeEquals(Value<?> target, Value<?>[] values) {
        ArrayList<double[]> result = new ArrayList<double[]>(values.length);
        for (Value<?> value : values) {
            double[] data = new double[]{target.getUnderlyingObject().equals(value.getUnderlyingObject()) ? 1.0 : 0.0};
            result.add(data);
        }
        return result;
    }

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public abstract Value<?> drop(Value<?> var1);

    public abstract Value<?> perturb(Value<?> var1, PerturbationContext var2);

    public abstract List<double[]> encode(Value<?> var1, Value<?> ... var2);
}

