/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

class DatasetEncoder {
    private final List<PredictionInput> perturbedInputs;
    private final List<Output> predictedOutputs;
    private final PredictionInput targetInput;
    private final Output originalOutput;

    DatasetEncoder(List<PredictionInput> perturbedInputs, List<Output> perturbedOutputs, PredictionInput targetInput, Output targetOutput) {
        this.perturbedInputs = perturbedInputs;
        this.predictedOutputs = perturbedOutputs;
        this.targetInput = targetInput;
        this.originalOutput = targetOutput;
    }

    List<Pair<double[], Double>> getEncodedTrainingSet() {
        LinkedList<Pair<double[], Double>> trainingSet = new LinkedList<Pair<double[], Double>>();
        List<PredictionInput> flatInputs = DataUtils.linearizeInputs(this.perturbedInputs);
        if (!(flatInputs.isEmpty() || this.predictedOutputs.isEmpty() || this.targetInput.getFeatures().isEmpty() || this.originalOutput == null)) {
            List<List<double[]>> columnData = this.getColumnData(flatInputs);
            int pi = 0;
            for (Output output : this.predictedOutputs) {
                double y;
                LinkedList<Double> x = new LinkedList<Double>();
                for (List<double[]> column : columnData) {
                    double[] doubles = column.get(pi);
                    x.addAll(Arrays.asList(ArrayUtils.toObject(doubles)));
                }
                if (Type.NUMBER.equals((Object)this.originalOutput.getType()) || Type.BOOLEAN.equals((Object)this.originalOutput.getType())) {
                    y = output.getValue().asNumber();
                } else {
                    Object originalObject = this.originalOutput.getValue().getUnderlyingObject();
                    Object outputObject = output.getValue().getUnderlyingObject();
                    y = originalObject == null || outputObject == null ? (originalObject == outputObject ? 1.0 : 0.0) : (originalObject.equals(outputObject) ? 1.0 : 0.0);
                }
                double[] input = new double[x.size()];
                int i = 0;
                for (Double d : x) {
                    input[i] = d;
                    ++i;
                }
                ImmutablePair<double[], Double> sample = new ImmutablePair<double[], Double>(input, y);
                trainingSet.add(sample);
                ++pi;
            }
        }
        return trainingSet;
    }

    private List<List<double[]>> getColumnData(List<PredictionInput> perturbedInputs) {
        LinkedList<List<double[]>> columnData = new LinkedList<List<double[]>>();
        int t = 0;
        while (t < this.targetInput.getFeatures().size()) {
            Feature targetFeature = this.targetInput.getFeatures().get(t);
            int finalT = t++;
            List<double[]> encode = targetFeature.getType().encode(targetFeature.getValue(), (Value[])perturbedInputs.stream().map(predictionInput -> predictionInput.getFeatures().get(finalT).getValue()).toArray(Value[]::new));
            columnData.add(encode);
        }
        return columnData;
    }
}

