/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.rest;

import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.kie.kogito.explainability.ExplanationService;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.ExplainabilityRequest;

@Path(value="/v1")
public class ExplainabilityApiV1 {
    protected ExplanationService explanationService;
    protected PredictionProviderFactory predictionProviderFactory;

    @Inject
    public ExplainabilityApiV1(ExplanationService explanationService, PredictionProviderFactory predictionProviderFactory) {
        this.explanationService = explanationService;
        this.predictionProviderFactory = predictionProviderFactory;
    }

    @POST
    @Path(value="/explain")
    @APIResponses(value={@APIResponse(description="Retrieve the explainability for a given decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ExplainabilityRequestDto.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Retrieve the explainability for a given decision.", description="Retrieve the explainability for a given decision.")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Uni<Response> explain(@Valid ExplainabilityRequestDto requestDto) {
        ExplainabilityRequest request = ExplainabilityRequest.from((ExplainabilityRequestDto)requestDto);
        PredictionProvider provider = this.predictionProviderFactory.createPredictionProvider(request);
        CompletionStage<Response> result = this.explanationService.explainAsync(request, provider).thenApply(x -> Response.ok((Object)x).build());
        return Uni.createFrom().completionStage(result);
    }
}

