/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger log = Logger.getLogger(BasicAuthenticationMechanism.class);
    public static final String SILENT = "silent";
    public static final String CHARSET = "charset";
    public static final String USER_AGENT_CHARSETS = "user-agent-charsets";
    private final String name;
    private final String challenge;
    private static final String BASIC = "basic";
    private static final String BASIC_PREFIX = "basic ";
    private static final String LOWERCASE_BASIC_PREFIX = "basic ".toLowerCase(Locale.ENGLISH);
    private static final int PREFIX_LENGTH = "basic ".length();
    private static final String COLON = ":";
    private final boolean silent;
    private final Charset charset;
    private final Map<Pattern, Charset> userAgentCharsets;

    public BasicAuthenticationMechanism(String realmName) {
        this(realmName, "BASIC");
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName) {
        this(realmName, mechanismName, false);
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent) {
        this(realmName, mechanismName, silent, StandardCharsets.UTF_8, Collections.emptyMap());
    }

    public BasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent, Charset charset, Map<Pattern, Charset> userAgentCharsets) {
        this.challenge = "basic realm=\"" + realmName + "\"";
        this.name = mechanismName;
        this.silent = silent;
        this.charset = charset;
        this.userAgentCharsets = Collections.unmodifiableMap(new LinkedHashMap<Pattern, Charset>(userAgentCharsets));
    }

    private static void clear(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }

    @Override
    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        List<String> authHeaders = context.request().headers().getAll(HttpHeaderNames.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                String ua;
                if (!current.toLowerCase(Locale.ENGLISH).startsWith(LOWERCASE_BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                String plainChallenge = null;
                byte[] decode = Base64.getDecoder().decode(base64Challenge);
                Charset charset = this.charset;
                if (!this.userAgentCharsets.isEmpty() && (ua = context.request().headers().get(HttpHeaderNames.USER_AGENT)) != null) {
                    for (Map.Entry<Pattern, Charset> entry : this.userAgentCharsets.entrySet()) {
                        if (!entry.getKey().matcher(ua).find()) continue;
                        charset = entry.getValue();
                        break;
                    }
                }
                plainChallenge = new String(decode, charset);
                log.debugf("Found basic auth header %s (decoded using charset %s)", (Object)plainChallenge, (Object)charset);
                int colonPos = plainChallenge.indexOf(COLON);
                if (colonPos > -1) {
                    String userName = plainChallenge.substring(0, colonPos);
                    char[] password = plainChallenge.substring(colonPos + 1).toCharArray();
                    UsernamePasswordAuthenticationRequest credential = new UsernamePasswordAuthenticationRequest(userName, new PasswordCredential(password));
                    return identityProviderManager.authenticate(credential);
                }
                return Uni.createFrom().failure(new AuthenticationFailedException());
            }
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        String authHeader;
        if (this.silent && (authHeader = context.request().headers().get(HttpHeaderNames.AUTHORIZATION)) == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), HttpHeaderNames.WWW_AUTHENTICATE, this.challenge);
        return Uni.createFrom().item(result);
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(UsernamePasswordAuthenticationRequest.class);
    }

    @Override
    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, BASIC);
    }
}

