/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class FilterUtil {
    private FilterUtil() {
    }

    public static final OpenAPI applyFilter(OASFilter filter, OpenAPI model) {
        FilterUtil.filterComponents(filter, model.getComponents());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterExternalDocs(filter, model.getExternalDocs());
        FilterUtil.filterInfo(filter, model.getInfo());
        FilterUtil.filterPaths(filter, model.getPaths());
        FilterUtil.filterSecurity(filter, model.getSecurity());
        FilterUtil.filterServers(filter, model.getServers());
        FilterUtil.filterTags(filter, model.getTags());
        filter.filterOpenAPI(model);
        return model;
    }

    private static void filterComponents(OASFilter filter, Components model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterCallbacks(filter, model.getCallbacks());
        FilterUtil.filterExamples(filter, model.getExamples());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterHeaders(filter, model.getHeaders());
        FilterUtil.filterLinks(filter, model.getLinks());
        FilterUtil.filterParameters(filter, model.getParameters());
        FilterUtil.filterRequestBodies(filter, model.getRequestBodies());
        FilterUtil.filterAPIResponses(filter, model.getResponses());
        FilterUtil.filterSchemas(filter, model.getSchemas());
        FilterUtil.filterSecuritySchemes(filter, model.getSecuritySchemes());
    }

    private static void filterCallbacks(OASFilter filter, Map<String, Callback> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Callback model = models.get(key);
            FilterUtil.filterCallback(filter, model);
            if (filter.filterCallback(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterCallback(OASFilter filter, Callback model) {
        if (model == null) {
            return;
        }
        ArrayList keys = new ArrayList(model.keySet());
        for (String key : keys) {
            PathItem childModel = model.getPathItem(key);
            FilterUtil.filterPathItem(filter, childModel);
            if (filter.filterPathItem(childModel) != null) continue;
            model.removePathItem(key);
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterPathItem(OASFilter filter, PathItem model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterParameterList(filter, model.getParameters());
        FilterUtil.filterOperation(filter, model.getDELETE());
        if (model.getDELETE() != null) {
            model.setDELETE(filter.filterOperation(model.getDELETE()));
        }
        FilterUtil.filterOperation(filter, model.getGET());
        if (model.getGET() != null) {
            model.setGET(filter.filterOperation(model.getGET()));
        }
        FilterUtil.filterOperation(filter, model.getHEAD());
        if (model.getHEAD() != null) {
            model.setHEAD(filter.filterOperation(model.getHEAD()));
        }
        FilterUtil.filterOperation(filter, model.getOPTIONS());
        if (model.getOPTIONS() != null) {
            model.setOPTIONS(filter.filterOperation(model.getOPTIONS()));
        }
        FilterUtil.filterOperation(filter, model.getPATCH());
        if (model.getPATCH() != null) {
            model.setPATCH(filter.filterOperation(model.getPATCH()));
        }
        FilterUtil.filterOperation(filter, model.getPOST());
        if (model.getPOST() != null) {
            model.setPOST(filter.filterOperation(model.getPOST()));
        }
        FilterUtil.filterOperation(filter, model.getPUT());
        if (model.getPUT() != null) {
            model.setPUT(filter.filterOperation(model.getPUT()));
        }
        FilterUtil.filterOperation(filter, model.getTRACE());
        if (model.getTRACE() != null) {
            model.setTRACE(filter.filterOperation(model.getTRACE()));
        }
        FilterUtil.filterServers(filter, model.getServers());
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterParameterList(OASFilter filter, List<Parameter> models) {
        if (models == null) {
            return;
        }
        ListIterator<Parameter> iterator = models.listIterator();
        while (iterator.hasNext()) {
            Parameter model = iterator.next();
            FilterUtil.filterParameter(filter, model);
            if (filter.filterParameter(model) != null) continue;
            iterator.remove();
        }
    }

    private static void filterOperation(OASFilter filter, Operation model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterCallbacks(filter, model.getCallbacks());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterExternalDocs(filter, model.getExternalDocs());
        FilterUtil.filterParameterList(filter, model.getParameters());
        FilterUtil.filterRequestBody(filter, model.getRequestBody());
        if (model.getRequestBody() != null && filter.filterRequestBody(model.getRequestBody()) == null) {
            model.setRequestBody(null);
        }
        FilterUtil.filterAPIResponses(filter, model.getResponses());
        FilterUtil.filterSecurity(filter, model.getSecurity());
        FilterUtil.filterServers(filter, model.getServers());
    }

    private static void filterExamples(OASFilter filter, Map<String, Example> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Example model = models.get(key);
            FilterUtil.filterExample(filter, model);
        }
    }

    private static void filterExample(OASFilter filter, Example model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterHeaders(OASFilter filter, Map<String, Header> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Header model = models.get(key);
            FilterUtil.filterHeader(filter, model);
            if (filter.filterHeader(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterHeader(OASFilter filter, Header model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterContent(filter, model.getContent());
        FilterUtil.filterExamples(filter, model.getExamples());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterSchema(filter, model.getSchema());
        if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
            model.setSchema(null);
        }
    }

    private static void filterContent(OASFilter filter, Content model) {
        if (model == null) {
            return;
        }
        ArrayList keys = new ArrayList(model.keySet());
        for (String key : keys) {
            MediaType childModel = model.getMediaType(key);
            FilterUtil.filterMediaType(filter, childModel);
        }
    }

    private static void filterMediaType(OASFilter filter, MediaType model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterEncoding(filter, model.getEncoding());
        FilterUtil.filterExamples(filter, model.getExamples());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterSchema(filter, model.getSchema());
        if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
            model.setSchema(null);
        }
    }

    private static void filterEncoding(OASFilter filter, Map<String, Encoding> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Encoding model = models.get(key);
            FilterUtil.filterEncoding(filter, model);
        }
    }

    private static void filterEncoding(OASFilter filter, Encoding model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterHeaders(filter, model.getHeaders());
    }

    private static void filterLinks(OASFilter filter, Map<String, Link> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Link model = models.get(key);
            FilterUtil.filterLink(filter, model);
            if (filter.filterLink(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterLink(OASFilter filter, Link model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterServer(filter, model.getServer());
        if (model.getServer() != null && filter.filterServer(model.getServer()) == null) {
            model.setServer(null);
        }
    }

    private static void filterParameters(OASFilter filter, Map<String, Parameter> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Parameter model = models.get(key);
            FilterUtil.filterParameter(filter, model);
            if (filter.filterParameter(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterParameter(OASFilter filter, Parameter model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterContent(filter, model.getContent());
        FilterUtil.filterExamples(filter, model.getExamples());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterSchema(filter, model.getSchema());
        if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
            model.setSchema(null);
        }
    }

    private static void filterRequestBodies(OASFilter filter, Map<String, RequestBody> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            RequestBody model = models.get(key);
            FilterUtil.filterRequestBody(filter, model);
            if (filter.filterRequestBody(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterRequestBody(OASFilter filter, RequestBody model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterContent(filter, model.getContent());
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterAPIResponses(OASFilter filter, Map<String, APIResponse> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            APIResponse model = models.get(key);
            FilterUtil.filterAPIResponse(filter, model);
            if (filter.filterAPIResponse(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterAPIResponse(OASFilter filter, APIResponse model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterContent(filter, model.getContent());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterHeaders(filter, model.getHeaders());
        FilterUtil.filterLinks(filter, model.getLinks());
    }

    private static void filterSchemas(OASFilter filter, Map<String, Schema> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            Schema model = models.get(key);
            FilterUtil.filterSchema(filter, model);
            if (filter.filterSchema(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterSchema(OASFilter filter, Schema model) {
        if (model == null) {
            return;
        }
        Schema ap = model.getAdditionalPropertiesSchema();
        if (ap != null) {
            FilterUtil.filterSchema(filter, ap);
            if (filter.filterSchema(ap) == null) {
                model.setAdditionalPropertiesSchema(null);
            }
        }
        FilterUtil.filterSchemaList(filter, model.getAllOf());
        FilterUtil.filterSchemaList(filter, model.getAnyOf());
        FilterUtil.filterDiscriminator(filter, model.getDiscriminator());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterExternalDocs(filter, model.getExternalDocs());
        FilterUtil.filterSchema(filter, model.getItems());
        if (model.getItems() != null && filter.filterSchema(model.getItems()) == null) {
            model.setItems(null);
        }
        FilterUtil.filterSchema(filter, model.getNot());
        if (model.getNot() != null && filter.filterSchema(model.getNot()) == null) {
            model.setNot(null);
        }
        FilterUtil.filterSchemas(filter, model.getProperties());
        FilterUtil.filterXML(filter, model.getXml());
    }

    private static void filterSchemaList(OASFilter filter, List<Schema> models) {
        if (models == null) {
            return;
        }
        ListIterator<Schema> iterator = models.listIterator();
        while (iterator.hasNext()) {
            Schema model = iterator.next();
            FilterUtil.filterSchema(filter, model);
            if (filter.filterSchema(model) != null) continue;
            iterator.remove();
        }
    }

    private static void filterDiscriminator(OASFilter filter, Discriminator model) {
        if (model == null) {
            return;
        }
    }

    private static void filterXML(OASFilter filter, XML model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterSecuritySchemes(OASFilter filter, Map<String, SecurityScheme> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(models.keySet());
        for (String key : keys) {
            SecurityScheme model = models.get(key);
            FilterUtil.filterSecurityScheme(filter, model);
            if (filter.filterSecurityScheme(model) != null) continue;
            models.remove(key);
        }
    }

    private static void filterSecurityScheme(OASFilter filter, SecurityScheme model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterOAuthFlows(filter, model.getFlows());
    }

    private static void filterOAuthFlows(OASFilter filter, OAuthFlows model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterOAuthFlow(filter, model.getAuthorizationCode());
        FilterUtil.filterOAuthFlow(filter, model.getClientCredentials());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterOAuthFlow(filter, model.getImplicit());
        FilterUtil.filterOAuthFlow(filter, model.getPassword());
    }

    private static void filterOAuthFlow(OASFilter filter, OAuthFlow model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterScopes(filter, model.getScopes());
    }

    private static void filterScopes(OASFilter filter, Scopes model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterExtensions(OASFilter filter, Map<String, Object> models) {
        if (models == null) {
            return;
        }
    }

    private static void filterExternalDocs(OASFilter filter, ExternalDocumentation model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterInfo(OASFilter filter, Info model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterContact(filter, model.getContact());
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterLicense(filter, model.getLicense());
    }

    private static void filterContact(OASFilter filter, Contact model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterLicense(OASFilter filter, License model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterPaths(OASFilter filter, Paths model) {
        if (model == null) {
            return;
        }
        ArrayList keys = new ArrayList(model.keySet());
        for (String key : keys) {
            PathItem childModel = model.getPathItem(key);
            FilterUtil.filterPathItem(filter, childModel);
            if (filter.filterPathItem(childModel) != null) continue;
            model.removePathItem(key);
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterSecurity(OASFilter filter, List<SecurityRequirement> models) {
        if (models == null) {
            return;
        }
        ListIterator<SecurityRequirement> iterator = models.listIterator();
        while (iterator.hasNext()) {
            SecurityRequirement model = iterator.next();
            FilterUtil.filterSecurityRequirement(filter, model);
        }
    }

    private static void filterSecurityRequirement(OASFilter filter, SecurityRequirement model) {
        if (model == null) {
            return;
        }
    }

    private static void filterServers(OASFilter filter, List<Server> models) {
        if (models == null) {
            return;
        }
        ListIterator<Server> iterator = models.listIterator();
        while (iterator.hasNext()) {
            Server model = iterator.next();
            FilterUtil.filterServer(filter, model);
            if (filter.filterServer(model) != null) continue;
            iterator.remove();
        }
    }

    private static void filterServer(OASFilter filter, Server model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterServerVariables(filter, model.getVariables());
    }

    private static void filterServerVariables(OASFilter filter, ServerVariables model) {
        if (model == null) {
            return;
        }
        ArrayList keys = new ArrayList(model.keySet());
        for (String key : keys) {
            ServerVariable childModel = model.getServerVariable(key);
            FilterUtil.filterServerVariable(filter, childModel);
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterServerVariable(OASFilter filter, ServerVariable model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
    }

    private static void filterTags(OASFilter filter, List<Tag> models) {
        if (models == null) {
            return;
        }
        ListIterator<Tag> iterator = models.listIterator();
        while (iterator.hasNext()) {
            Tag model = iterator.next();
            FilterUtil.filterTag(filter, model);
            if ((model = filter.filterTag(model)) != null) continue;
            iterator.remove();
        }
    }

    private static void filterTag(OASFilter filter, Tag model) {
        if (model == null) {
            return;
        }
        FilterUtil.filterExtensions(filter, model.getExtensions());
        FilterUtil.filterExternalDocs(filter, model.getExternalDocs());
    }
}

