/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class FilteredIndexView
implements IndexView {
    private final IndexView delegate;
    private final Set<String> scanClasses;
    private final Set<String> scanPackages;
    private final Set<String> scanExcludeClasses;
    private final Set<String> scanExcludePackages;

    public FilteredIndexView(IndexView delegate, OpenApiConfig config) {
        this.delegate = delegate;
        this.scanClasses = config.scanClasses();
        this.scanPackages = config.scanPackages();
        this.scanExcludeClasses = config.scanExcludeClasses();
        this.scanExcludePackages = config.scanExcludePackages();
    }

    private boolean accepts(DotName className) {
        boolean accept;
        String packageName;
        String fqcn = className.toString();
        int index = fqcn.lastIndexOf(46);
        String string = packageName = index > -1 ? fqcn.substring(0, index) : "";
        if (this.scanClasses.isEmpty() && this.scanPackages.isEmpty()) {
            accept = true;
        } else if (!this.scanClasses.isEmpty() && this.scanPackages.isEmpty()) {
            accept = this.scanClasses.contains(fqcn);
        } else if (this.scanClasses.isEmpty() && !this.scanPackages.isEmpty()) {
            accept = this.scanPackages.contains(packageName);
        } else {
            boolean bl = accept = this.scanClasses.contains(fqcn) || this.scanPackages.contains(packageName);
        }
        if (!this.scanExcludeClasses.isEmpty() && this.scanExcludeClasses.contains(fqcn)) {
            accept = false;
        }
        if (!this.scanExcludePackages.isEmpty() && this.scanExcludePackages.contains(packageName)) {
            accept = false;
        }
        return accept;
    }

    @Override
    public Collection<ClassInfo> getKnownClasses() {
        return this.delegate.getKnownClasses().stream().filter(ci -> this.accepts(ci.name())).collect(Collectors.toList());
    }

    @Override
    public ClassInfo getClassByName(DotName className) {
        if (this.accepts(className)) {
            return this.delegate.getClassByName(className);
        }
        return null;
    }

    @Override
    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        return this.delegate.getKnownDirectSubclasses(className).stream().filter(ci -> this.accepts(ci.name())).collect(Collectors.toList());
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        return this.delegate.getAllKnownSubclasses(className).stream().filter(ci -> this.accepts(ci.name())).collect(Collectors.toList());
    }

    @Override
    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        return this.delegate.getKnownDirectImplementors(className).stream().filter(ci -> this.accepts(ci.name())).collect(Collectors.toList());
    }

    @Override
    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        return this.delegate.getAllKnownImplementors(interfaceName).stream().filter(ci -> this.accepts(ci.name())).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        return this.delegate.getAnnotations(annotationName).stream().filter(ai -> {
            AnnotationTarget target = ai.target();
            switch (target.kind()) {
                case CLASS: {
                    return this.accepts(target.asClass().name());
                }
                case FIELD: {
                    return this.accepts(target.asField().declaringClass().name());
                }
                case METHOD: {
                    return this.accepts(target.asMethod().declaringClass().name());
                }
                case METHOD_PARAMETER: {
                    return this.accepts(target.asMethodParameter().method().declaringClass().name());
                }
                case TYPE: {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }
}

