/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.devmode.ReplacementDebugPage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

public class VertxHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext hotReplacementContext;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    private static final String HEADER_NAME = "x-quarkus-hot-deployment-done";

    @Override
    public void setupHotDeployment(HotReplacementContext context) {
        this.hotReplacementContext = context;
        VertxHttpRecorder.setHotReplacement(this::handleHotReplacementRequest);
    }

    @Override
    public void handleFailedInitialStart() {
        VertxHttpRecorder.startServerAfterFailedStart();
    }

    void handleHotReplacementRequest(final RoutingContext routingContext) {
        if (this.nextUpdate > System.currentTimeMillis() && !this.hotReplacementContext.isTest() || routingContext.request().headers().contains(HEADER_NAME)) {
            if (this.hotReplacementContext.getDeploymentProblem() != null) {
                VertxHotReplacementSetup.handleDeploymentProblem(routingContext, this.hotReplacementContext.getDeploymentProblem());
                return;
            }
            routingContext.next();
            return;
        }
        routingContext.vertx().executeBlocking(new Handler<Promise<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Promise<Boolean> event) {
                boolean restart = false;
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (VertxHotReplacementSetup.this.nextUpdate < System.currentTimeMillis() || VertxHotReplacementSetup.this.hotReplacementContext.isTest()) {
                        VertxHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                        try {
                            restart = VertxHotReplacementSetup.this.hotReplacementContext.doScan(true);
                        }
                        catch (Exception e) {
                            event.fail(new IllegalStateException("Unable to perform hot replacement scanning", e));
                            return;
                        }
                    }
                }
                if (VertxHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem() != null) {
                    event.fail(VertxHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem());
                    return;
                }
                event.complete(restart);
            }
        }, false, new Handler<AsyncResult<Boolean>>(){

            @Override
            public void handle(AsyncResult<Boolean> event) {
                if (event.failed()) {
                    VertxHotReplacementSetup.handleDeploymentProblem(routingContext, event.cause());
                } else {
                    boolean restart = event.result();
                    if (restart) {
                        routingContext.request().headers().set(VertxHotReplacementSetup.HEADER_NAME, "true");
                        VertxHttpRecorder.getRootHandler().handle(routingContext.request());
                    } else {
                        routingContext.next();
                    }
                }
            }
        });
    }

    public static void handleDeploymentProblem(RoutingContext routingContext, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml(exception);
        HttpServerResponse response = routingContext.response();
        response.setStatusCode(500);
        response.headers().add("Content-Type", "text/html; charset=UTF-8");
        response.end(bodyText);
    }

    @Override
    public void close() {
        VertxHttpRecorder.shutDownDevMode();
    }
}

