/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class TypeProcessor {
    private static final Logger LOG = Logger.getLogger(TypeProcessor.class);
    private final Schema schema;
    private final AugmentedIndexView index;
    private final AnnotationTarget annotationTarget;
    private final DataObjectDeque objectStack;
    private final TypeResolver typeResolver;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private Type type;

    public TypeProcessor(AugmentedIndexView index, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, Type type, Schema schema, AnnotationTarget annotationTarget) {
        this.objectStack = objectStack;
        this.typeResolver = typeResolver;
        this.parentPathEntry = parentPathEntry;
        this.type = type;
        this.schema = schema;
        this.index = index;
        this.annotationTarget = annotationTarget;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Type processType() {
        if (TypeUtil.isTerminalType(this.type)) {
            return this.type;
        }
        if (this.type.kind() == Type.Kind.WILDCARD_TYPE) {
            this.type = TypeUtil.resolveWildcard(this.type.asWildcardType());
        }
        if (this.type.kind() == Type.Kind.ARRAY) {
            LOG.debugv("Processing an array {0}", (Object)this.type);
            ArrayType arrayType = this.type.asArrayType();
            Schema arrSchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            TypeUtil.applyTypeAttributes(arrayType.component(), arrSchema);
            if (!TypeUtil.isTerminalType(arrayType.component()) && this.index.containsClass(this.type)) {
                this.pushToStack(this.type, arrSchema);
            }
            arrSchema = SchemaRegistry.checkRegistration(arrayType.component(), this.typeResolver, arrSchema);
            while (arrayType.dimensions() > 1) {
                SchemaImpl parentArrSchema = new SchemaImpl();
                parentArrSchema.setType(Schema.SchemaType.ARRAY);
                parentArrSchema.items(arrSchema);
                arrSchema = parentArrSchema;
                arrayType = ArrayType.create(arrayType.component(), arrayType.dimensions() - 1);
            }
            this.schema.items(arrSchema);
            return arrayType;
        }
        if (TypeUtil.isOptional(this.type)) {
            Type optType = TypeUtil.getOptionalType(this.type);
            if (!TypeUtil.isTerminalType(optType) && this.index.containsClass(optType)) {
                this.pushToStack(optType);
            }
            return optType;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ENUM_TYPE) && this.index.containsClass(this.type)) {
            MergeUtil.mergeObjects(this.schema, SchemaFactory.enumToSchema(this.index, this.type));
            return OpenApiDataObjectScanner.STRING_TYPE;
        }
        if (this.type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.readParameterizedType(this.type.asParameterizedType());
        }
        if (this.type.kind() == Type.Kind.TYPE_VARIABLE || this.type.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
            return this.resolveTypeVariable(this.schema, this.type);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.COLLECTION_TYPE)) {
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.MAP_TYPE)) {
            return OpenApiDataObjectScanner.OBJECT_TYPE;
        }
        if (this.index.containsClass(this.type)) {
            this.pushToStack(this.type);
        } else {
            LOG.debugv("Encountered type not in Jandex index that is not well-known type. Will not traverse it: {0}", (Object)this.type);
        }
        return this.type;
    }

    private Type readParameterizedType(ParameterizedType pType) {
        LOG.debugv("Processing parameterized type {0}", (Object)pType);
        Type typeRead = pType;
        if (this.isA(pType, OpenApiDataObjectScanner.COLLECTION_TYPE) || this.isA(pType, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            LOG.debugv("Processing Java Collection. Will treat as an array.", new Object[0]);
            Schema arraySchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            Type arg = pType.arguments().get(0);
            if (TypeUtil.isTerminalType(arg)) {
                TypeUtil.applyTypeAttributes(arg, arraySchema);
            } else {
                arraySchema = this.resolveParameterizedType(arg, arraySchema);
            }
            this.schema.items(arraySchema);
            typeRead = OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        } else if (this.isA(pType, OpenApiDataObjectScanner.MAP_TYPE)) {
            LOG.debugv("Processing Map. Will treat as an object.", new Object[0]);
            this.schema.type(Schema.SchemaType.OBJECT);
            if (pType.arguments().size() == 2) {
                Type valueType = pType.arguments().get(1);
                Schema propsSchema = new SchemaImpl();
                if (TypeUtil.isTerminalType(valueType)) {
                    TypeUtil.applyTypeAttributes(valueType, propsSchema);
                } else {
                    propsSchema = this.resolveParameterizedType(valueType, propsSchema);
                }
                this.schema.additionalPropertiesSchema(propsSchema);
            }
            typeRead = OpenApiDataObjectScanner.OBJECT_TYPE;
        } else if (this.index.containsClass(this.type)) {
            this.pushToStack(pType);
        }
        return typeRead;
    }

    private Schema resolveParameterizedType(Type valueType, Schema propsSchema) {
        if (valueType.kind() == Type.Kind.TYPE_VARIABLE || valueType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || valueType.kind() == Type.Kind.WILDCARD_TYPE) {
            Type resolved = this.resolveTypeVariable(propsSchema, valueType);
            if (this.index.containsClass(resolved)) {
                propsSchema.type(Schema.SchemaType.OBJECT);
                propsSchema = SchemaRegistry.checkRegistration(valueType, this.typeResolver, propsSchema);
            }
        } else if (this.index.containsClass(valueType)) {
            if (this.isA(valueType, OpenApiDataObjectScanner.ENUM_TYPE)) {
                LOG.debugv("Processing an enum {0}", (Object)valueType);
                propsSchema = SchemaFactory.enumToSchema(this.index, valueType);
            } else {
                propsSchema.type(Schema.SchemaType.OBJECT);
                this.pushToStack(valueType, propsSchema);
            }
            propsSchema = SchemaRegistry.checkRegistration(valueType, this.typeResolver, propsSchema);
        }
        return propsSchema;
    }

    private Type resolveTypeVariable(Schema schema, Type fieldType) {
        Type resolvedType = this.typeResolver.getResolvedType(fieldType);
        LOG.debugv("Resolved type {0} -> {1}", (Object)fieldType, (Object)resolvedType);
        if (TypeUtil.isTerminalType(resolvedType) || !this.index.containsClass(resolvedType)) {
            LOG.debugv("Is a terminal type {0}", (Object)resolvedType);
            TypeUtil.applyTypeAttributes(resolvedType, schema);
        } else {
            LOG.debugv("Attempting to do TYPE_VARIABLE substitution: {0} -> {1}", (Object)fieldType, (Object)resolvedType);
            if (this.index.containsClass(resolvedType)) {
                this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
            } else {
                LOG.debugv("Class for type {0} not available", (Object)resolvedType);
            }
        }
        return resolvedType;
    }

    private void pushToStack(Type fieldType) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, fieldType, this.schema);
    }

    private void pushToStack(Type resolvedType, Schema schema) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
    }

    private boolean isA(Type testSubject, Type test2) {
        return TypeUtil.isA(this.index, testSubject, test2);
    }
}

