/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniFlatMapOnItem;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniFlatMapOnFailure<I>
extends UniOperator<I, I> {
    private final Function<? super Throwable, ? extends Uni<? extends I>> mapper;
    private final Predicate<? super Throwable> predicate;

    public UniFlatMapOnFailure(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Uni<? extends I>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super I> subscriber) {
        final UniFlatMapOnItem.FlatMapSubscription flatMapSubscription = new UniFlatMapOnItem.FlatMapSubscription();
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, I>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                flatMapSubscription.setInitialUpstream(subscription);
                subscriber.onSubscribe(flatMapSubscription);
            }

            @Override
            public void onFailure(Throwable failure) {
                boolean test2;
                try {
                    test2 = UniFlatMapOnFailure.this.predicate.test(failure);
                }
                catch (RuntimeException e) {
                    subscriber.onFailure(new CompositeException(failure, e));
                    return;
                }
                if (test2) {
                    UniFlatMapOnItem.invokeAndSubstitute(UniFlatMapOnFailure.this.mapper, failure, subscriber, flatMapSubscription);
                } else {
                    subscriber.onFailure(failure);
                }
            }
        });
    }
}

