/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AnnotationTargetProcessor
implements BeanValidationScanner.RequirementHandler {
    private static final Logger LOG = Logger.getLogger(AnnotationTargetProcessor.class);
    private final AugmentedIndexView index;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final Type entityType;
    private AnnotationTarget annotationTarget;

    public AnnotationTargetProcessor(AugmentedIndexView index, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, Type entityType) {
        this.index = index;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
    }

    public static Schema process(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, objectStack, parentPathEntry, typeResolver, typeResolver.getAnnotationTarget(), typeResolver.getUnresolvedType());
        return fp.processField();
    }

    public static Schema process(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, objectStack, parentPathEntry, typeResolver, index.getClass(type), type);
        return fp.processField();
    }

    @Override
    public void setRequired(AnnotationTarget target, String propertyKey) {
        AnnotationInstance schemaAnnotation;
        List<String> requiredProperties = this.parentPathEntry.getSchema().getRequired();
        if (!(requiredProperties != null && requiredProperties.contains(propertyKey) || (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && schemaAnnotation.value("required") != null)) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
    }

    Schema processField() {
        Type fieldType;
        Reference registeredTypeSchema;
        Schema typeSchema;
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.annotationTarget);
        String propertyKey = this.typeResolver.getPropertyName();
        if (schemaAnnotation != null && JandexUtil.hasImplementation(schemaAnnotation)) {
            typeSchema = null;
            registeredTypeSchema = null;
            fieldType = (Type)JandexUtil.value(schemaAnnotation, "implementation");
        } else {
            TypeProcessor typeProcessor = new TypeProcessor(this.index, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, new SchemaImpl(), this.annotationTarget);
            fieldType = typeProcessor.processType();
            typeSchema = typeProcessor.getSchema();
            TypeUtil.applyTypeAttributes(fieldType, typeSchema);
            Type registrationType = TypeUtil.isOptional(this.entityType) ? fieldType : this.entityType;
            registeredTypeSchema = SchemaRegistry.checkRegistration(registrationType, this.typeResolver, typeSchema);
        }
        Reference<Schema> fieldSchema = schemaAnnotation != null ? this.readSchemaAnnotatedField(propertyKey, schemaAnnotation, fieldType) : (Schema)MergeUtil.mergeObjects(new SchemaImpl(), typeSchema);
        BeanValidationScanner.applyConstraints(this.annotationTarget, fieldSchema, propertyKey, this);
        if (fieldSchema.getNullable() == null && TypeUtil.isOptional(this.entityType)) {
            fieldSchema.setNullable(Boolean.TRUE);
        }
        if (typeSchema != registeredTypeSchema && registeredTypeSchema.getRef() != null) {
            if (this.fieldOverridesType((Schema)fieldSchema, typeSchema)) {
                TypeUtil.clearMatchingDefaultAttributes(fieldSchema, typeSchema);
                SchemaImpl composition = new SchemaImpl();
                composition.addAllOf((Schema)registeredTypeSchema);
                composition.addAllOf((Schema)fieldSchema);
                fieldSchema = composition;
            } else {
                fieldSchema = registeredTypeSchema;
            }
        } else {
            fieldSchema = MergeUtil.mergeObjects(typeSchema, fieldSchema);
        }
        this.parentPathEntry.getSchema().addProperty(propertyKey, (Schema)fieldSchema);
        return fieldSchema;
    }

    private Schema readSchemaAnnotatedField(String propertyKey, AnnotationInstance annotation, Type postProcessedField) {
        LOG.debugv("Processing @Schema annotation {0} on a field {1}", (Object)annotation, (Object)propertyKey);
        if (JandexUtil.booleanValueWithDefault(annotation, "required")) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        Map<Object, Object> defaults = JandexUtil.isArraySchema(annotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(postProcessedField);
        return SchemaFactory.readSchema((IndexView)this.index, (Schema)new SchemaImpl(), annotation, defaults);
    }

    boolean fieldOverridesType(Schema fieldSchema, Schema typeSchema) {
        List<Supplier<Object>> typeAttributes = this.getAttributeSuppliers(typeSchema);
        List<Supplier<Object>> fieldAttributes = this.getAttributeSuppliers(fieldSchema);
        int m = typeAttributes.size();
        for (int i = 0; i < m; ++i) {
            Object typeAttr;
            Object fieldAttr = fieldAttributes.get(i).get();
            if (fieldAttr == null || (typeAttr = typeAttributes.get(i).get()) != null && fieldAttr.equals(typeAttr)) continue;
            return true;
        }
        return false;
    }

    List<Supplier<Object>> getAttributeSuppliers(Schema schema) {
        Supplier[] supplierArray = new Supplier[38];
        supplierArray[0] = schema::getAdditionalPropertiesBoolean;
        supplierArray[1] = schema::getAdditionalPropertiesSchema;
        supplierArray[2] = schema::getAllOf;
        supplierArray[3] = schema::getAnyOf;
        supplierArray[4] = schema::getDefaultValue;
        supplierArray[5] = schema::getDeprecated;
        supplierArray[6] = schema::getDescription;
        supplierArray[7] = schema::getDiscriminator;
        supplierArray[8] = schema::getEnumeration;
        supplierArray[9] = schema::getExample;
        supplierArray[10] = schema::getExclusiveMaximum;
        supplierArray[11] = schema::getExclusiveMinimum;
        supplierArray[12] = schema::getExtensions;
        supplierArray[13] = schema::getExternalDocs;
        supplierArray[14] = schema::getFormat;
        supplierArray[15] = schema::getItems;
        supplierArray[16] = schema::getMaximum;
        supplierArray[17] = schema::getMaxItems;
        supplierArray[18] = schema::getMaxLength;
        supplierArray[19] = schema::getMaxProperties;
        supplierArray[20] = schema::getMinimum;
        supplierArray[21] = schema::getMinItems;
        supplierArray[22] = schema::getMinLength;
        supplierArray[23] = schema::getMinProperties;
        supplierArray[24] = schema::getMultipleOf;
        supplierArray[25] = schema::getNot;
        supplierArray[26] = schema::getNullable;
        supplierArray[27] = schema::getOneOf;
        supplierArray[28] = schema::getPattern;
        supplierArray[29] = schema::getProperties;
        supplierArray[30] = schema::getReadOnly;
        supplierArray[31] = schema::getRef;
        supplierArray[32] = schema::getRequired;
        supplierArray[33] = schema::getTitle;
        supplierArray[34] = schema::getType;
        supplierArray[35] = schema::getUniqueItems;
        supplierArray[36] = schema::getWriteOnly;
        supplierArray[37] = schema::getXml;
        return Arrays.asList(supplierArray);
    }
}

