/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.ConversionUtils;
import org.kie.kogito.explainability.ExplanationService;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.models.ExplainabilityRequest;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplanationServiceImpl
implements ExplanationService {
    static final String FAILED_STATUS_DETAILS = "Failed to calculate values";
    private static final Logger LOG = LoggerFactory.getLogger(ExplanationServiceImpl.class);
    private final LocalExplainer<Map<String, Saliency>> localExplainer;

    @Inject
    public ExplanationServiceImpl(LocalExplainer<Map<String, Saliency>> localExplainer) {
        this.localExplainer = localExplainer;
    }

    @Override
    public CompletionStage<ExplainabilityResultDto> explainAsync(ExplainabilityRequest request, PredictionProvider predictionProvider) {
        LOG.debug("Explainability request with executionId {} for model {}:{}", new Object[]{request.getExecutionId(), request.getModelIdentifier().getResourceType(), request.getModelIdentifier().getResourceId()});
        try {
            return ((CompletableFuture)this.localExplainer.explainAsync(ExplanationServiceImpl.getPrediction(request.getInputs(), request.getOutputs()), predictionProvider).thenApply(input -> ExplanationServiceImpl.createSucceededResultDto(request.getExecutionId(), input))).exceptionally(e -> ExplanationServiceImpl.createFailedResultDto(request.getExecutionId(), e));
        }
        catch (Exception e2) {
            return CompletableFuture.completedFuture(ExplanationServiceImpl.createFailedResultDto(request.getExecutionId(), e2));
        }
    }

    private static ExplainabilityResultDto createSucceededResultDto(String executionId, Map<String, Saliency> saliencies) {
        return ExplainabilityResultDto.buildSucceeded((String)executionId, saliencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SaliencyDto(((Saliency)e.getValue()).getPerFeatureImportance().stream().map(fi -> new FeatureImportanceDto(fi.getFeature().getName(), Double.valueOf(fi.getScore()))).collect(Collectors.toList())))));
    }

    private static ExplainabilityResultDto createFailedResultDto(String executionId, Throwable throwable) {
        LOG.error("Exception thrown during explainAsync", throwable);
        return ExplainabilityResultDto.buildFailed((String)executionId, (String)FAILED_STATUS_DETAILS);
    }

    private static Prediction getPrediction(Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        PredictionInput input = ExplanationServiceImpl.getPredictionInput(inputs);
        PredictionOutput output = ExplanationServiceImpl.getPredictionOutput(outputs);
        return new Prediction(input, output);
    }

    private static PredictionInput getPredictionInput(Map<String, TypedValue> inputs) {
        return new PredictionInput(ConversionUtils.toFeatureList(inputs));
    }

    private static PredictionOutput getPredictionOutput(Map<String, TypedValue> outputs) {
        return new PredictionOutput(ConversionUtils.toOutputList(outputs));
    }
}

