/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.ConversionUtils;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandler;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.SimplePrediction;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;
import org.kie.kogito.explainability.models.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.kie.kogito.tracing.typedvalue.TypedValue;

@ApplicationScoped
public class LimeExplainerServiceHandler
implements LocalExplainerServiceHandler<Map<String, Saliency>, LIMEExplainabilityRequest, LIMEExplainabilityRequestDto> {
    private final LimeExplainer explainer;
    private final PredictionProviderFactory predictionProviderFactory;

    @Inject
    public LimeExplainerServiceHandler(LimeExplainer explainer, PredictionProviderFactory predictionProviderFactory) {
        this.explainer = explainer;
        this.predictionProviderFactory = predictionProviderFactory;
    }

    @Override
    public <T extends BaseExplainabilityRequest> boolean supports(Class<T> type) {
        return LIMEExplainabilityRequest.class.isAssignableFrom(type);
    }

    @Override
    public <T extends BaseExplainabilityRequestDto> boolean supportsDto(Class<T> type) {
        return LIMEExplainabilityRequestDto.class.isAssignableFrom(type);
    }

    @Override
    public LIMEExplainabilityRequest explainabilityRequestFrom(LIMEExplainabilityRequestDto dto) {
        return new LIMEExplainabilityRequest(dto.getExecutionId(), dto.getServiceUrl(), ModelIdentifier.from(dto.getModelIdentifier()), dto.getInputs(), dto.getOutputs());
    }

    @Override
    public PredictionProvider getPredictionProvider(LIMEExplainabilityRequest request) {
        return this.predictionProviderFactory.createPredictionProvider(request.getServiceUrl(), request.getModelIdentifier(), request.getOutputs());
    }

    @Override
    public Prediction getPrediction(LIMEExplainabilityRequest request) {
        Map<String, TypedValue> inputs = request.getInputs();
        Map<String, TypedValue> outputs = request.getOutputs();
        PredictionInput input = new PredictionInput(ConversionUtils.toFeatureList(inputs));
        PredictionOutput output = new PredictionOutput(ConversionUtils.toOutputList(outputs));
        return new SimplePrediction(input, output);
    }

    @Override
    public BaseExplainabilityResultDto createSucceededResultDto(LIMEExplainabilityRequest request, Map<String, Saliency> result) {
        return LIMEExplainabilityResultDto.buildSucceeded((String)request.getExecutionId(), result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SaliencyDto(((Saliency)e.getValue()).getPerFeatureImportance().stream().map(fi -> new FeatureImportanceDto(fi.getFeature().getName(), Double.valueOf(fi.getScore()))).collect(Collectors.toList())))));
    }

    @Override
    public BaseExplainabilityResultDto createIntermediateResultDto(LIMEExplainabilityRequest request, Map<String, Saliency> result) {
        throw new UnsupportedOperationException("Intermediate results are not supported by LIME.");
    }

    @Override
    public BaseExplainabilityResultDto createFailedResultDto(LIMEExplainabilityRequest request, Throwable throwable) {
        return LIMEExplainabilityResultDto.buildFailed((String)request.getExecutionId(), (String)throwable.getMessage());
    }

    public CompletableFuture<Map<String, Saliency>> explainAsync(Prediction prediction, PredictionProvider predictionProvider, Consumer<Map<String, Saliency>> intermediateResultsConsumer) {
        return this.explainer.explainAsync(prediction, predictionProvider, intermediateResultsConsumer);
    }
}

