/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.ExplanationServiceImpl;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceModel;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.explainability.api.ModelIdentifier;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.explainability.api.SaliencyModel;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandlerRegistry;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ExplanationServiceImplTest {
    private static final Long MAX_RUNNING_TIME_SECONDS = 60L;
    Instance instance;
    ExplanationServiceImpl explanationService;
    LimeExplainer limeExplainerMock;
    LimeExplainerServiceHandler limeExplainerServiceHandlerMock;
    CounterfactualExplainer cfExplainerMock;
    CounterfactualExplainerServiceHandler cfExplainerServiceHandlerMock;
    LocalExplainerServiceHandlerRegistry explainerServiceHandlerRegistryMock;
    PredictionProvider predictionProviderMock;
    Consumer<BaseExplainabilityResult> callbackMock;

    ExplanationServiceImplTest() {
    }

    @BeforeEach
    void init() {
        this.instance = (Instance)Mockito.mock(Instance.class);
        this.limeExplainerMock = (LimeExplainer)Mockito.mock(LimeExplainer.class);
        this.cfExplainerMock = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        PredictionProviderFactory predictionProviderFactory = (PredictionProviderFactory)Mockito.mock(PredictionProviderFactory.class);
        this.explainerServiceHandlerRegistryMock = new LocalExplainerServiceHandlerRegistry(this.instance);
        this.limeExplainerServiceHandlerMock = (LimeExplainerServiceHandler)Mockito.spy((Object)new LimeExplainerServiceHandler(this.limeExplainerMock, predictionProviderFactory));
        this.cfExplainerServiceHandlerMock = (CounterfactualExplainerServiceHandler)Mockito.spy((Object)new CounterfactualExplainerServiceHandler(this.cfExplainerMock, predictionProviderFactory, MAX_RUNNING_TIME_SECONDS));
        this.predictionProviderMock = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.callbackMock = (Consumer)Mockito.mock(Consumer.class);
        this.explanationService = new ExplanationServiceImpl(this.explainerServiceHandlerRegistryMock);
        Mockito.when((Object)predictionProviderFactory.createPredictionProvider((String)ArgumentMatchers.any(), (ModelIdentifier)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).thenReturn((Object)this.predictionProviderMock);
    }

    @Test
    void testLIMEExplainAsyncSucceeded() {
        this.testLIMEExplainAsyncSuccess((ThrowingSupplier<BaseExplainabilityResult>)((ThrowingSupplier)() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())));
    }

    @Test
    void testLIMEExplainAsyncSucceededWithoutCallback() {
        this.testLIMEExplainAsyncSuccess((ThrowingSupplier<BaseExplainabilityResult>)((ThrowingSupplier)() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())));
    }

    void testLIMEExplainAsyncSuccess(ThrowingSupplier<BaseExplainabilityResult> invocation) {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        Mockito.when((Object)this.limeExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock), (Consumer)ArgumentMatchers.any(Consumer.class))).thenReturn(CompletableFuture.completedFuture(TestUtils.SALIENCY_MAP));
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(invocation);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof LIMEExplainabilityResult));
        LIMEExplainabilityResult limeResult = (LIMEExplainabilityResult)result;
        Assertions.assertEquals((Object)TestUtils.EXECUTION_ID, (Object)limeResult.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.SUCCEEDED, (Object)limeResult.getStatus());
        Assertions.assertNull((Object)limeResult.getStatusDetails());
        Assertions.assertEquals((int)TestUtils.SALIENCY_MAP.size(), (int)limeResult.getSaliencies().size());
        SaliencyModel saliency = (SaliencyModel)limeResult.getSaliencies().iterator().next();
        Assertions.assertEquals((int)TestUtils.SALIENCY.getPerFeatureImportance().size(), (int)saliency.getFeatureImportance().size());
        FeatureImportanceModel featureImportance1 = (FeatureImportanceModel)saliency.getFeatureImportance().get(0);
        Assertions.assertEquals((Object)TestUtils.FEATURE_IMPORTANCE_1.getFeature().getName(), (Object)featureImportance1.getFeatureName());
        Assertions.assertEquals((double)TestUtils.FEATURE_IMPORTANCE_1.getScore(), (double)featureImportance1.getFeatureScore(), (double)0.01);
    }

    @Test
    void testCounterfactualsExplainAsyncSucceeded() {
        this.testCounterfactualsExplainAsyncSuccess((ThrowingSupplier<BaseExplainabilityResult>)((ThrowingSupplier)() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.COUNTERFACTUAL_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())));
    }

    @Test
    void testCounterfactualsExplainAsyncSucceededWithoutCallback() {
        this.testCounterfactualsExplainAsyncSuccess((ThrowingSupplier<BaseExplainabilityResult>)((ThrowingSupplier)() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.COUNTERFACTUAL_REQUEST).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())));
    }

    void testCounterfactualsExplainAsyncSuccess(ThrowingSupplier<BaseExplainabilityResult> invocation) {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.cfExplainerServiceHandlerMock));
        Mockito.when((Object)this.cfExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock), (Consumer)ArgumentMatchers.any(Consumer.class))).thenReturn(CompletableFuture.completedFuture(TestUtils.COUNTERFACTUAL_RESULT));
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(invocation);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof CounterfactualExplainabilityResult));
        CounterfactualExplainabilityResult counterfactualResult = (CounterfactualExplainabilityResult)result;
        Assertions.assertEquals((Object)TestUtils.EXECUTION_ID, (Object)counterfactualResult.getExecutionId());
        Assertions.assertEquals((Object)TestUtils.COUNTERFACTUAL_ID, (Object)counterfactualResult.getCounterfactualId());
        Assertions.assertSame((Object)ExplainabilityStatus.SUCCEEDED, (Object)counterfactualResult.getStatus());
        Assertions.assertNull((Object)counterfactualResult.getStatusDetails());
        Assertions.assertEquals((int)TestUtils.COUNTERFACTUAL_RESULT.getEntities().size(), (int)counterfactualResult.getInputs().size());
        Assertions.assertEquals((int)TestUtils.COUNTERFACTUAL_RESULT.getOutput().size(), (int)counterfactualResult.getOutputs().size());
        Assertions.assertTrue((boolean)counterfactualResult.getOutputs().stream().anyMatch(o -> o.getName().equals("output1")));
        NamedTypedValue value = (NamedTypedValue)counterfactualResult.getOutputs().iterator().next();
        Assertions.assertTrue((boolean)value.getValue().isUnit());
        Assertions.assertEquals((Object)Double.class.getSimpleName(), (Object)((UnitValue)value.getValue().toUnit()).getType());
        Assertions.assertEquals((double)555.0, (double)((UnitValue)value.getValue().toUnit()).getValue().asDouble());
    }

    @Test
    void testServiceCallFailed() {
        String errorMessage = "Something bad happened";
        RuntimeException exception = new RuntimeException(errorMessage);
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        ((LimeExplainerServiceHandler)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.limeExplainerServiceHandlerMock)).supports((Class)ArgumentMatchers.any());
        Assertions.assertThrows(RuntimeException.class, () -> this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
    }

    @Test
    void testServiceCallFailedNoMatchingServiceHandlers() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
    }

    @Test
    void testLIMEExplainAsyncFailed() {
        String errorMessage = "Something bad happened";
        RuntimeException exception = new RuntimeException(errorMessage);
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        Mockito.when((Object)this.limeExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock), (Consumer)ArgumentMatchers.any(Consumer.class))).thenThrow(new Throwable[]{exception});
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof LIMEExplainabilityResult));
        LIMEExplainabilityResult exceptionResult = (LIMEExplainabilityResult)result;
        Assertions.assertEquals((Object)TestUtils.EXECUTION_ID, (Object)exceptionResult.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.FAILED, (Object)exceptionResult.getStatus());
        Assertions.assertEquals((Object)errorMessage, (Object)exceptionResult.getStatusDetails());
    }

    @Test
    void testCounterfactualsxplainAsyncFailed() {
        String errorMessage = "Something bad happened";
        RuntimeException exception = new RuntimeException(errorMessage);
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.cfExplainerServiceHandlerMock));
        Mockito.when((Object)this.cfExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock), (Consumer)ArgumentMatchers.any(Consumer.class))).thenThrow(new Throwable[]{exception});
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.COUNTERFACTUAL_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof CounterfactualExplainabilityResult));
        CounterfactualExplainabilityResult exceptionResult = (CounterfactualExplainabilityResult)result;
        Assertions.assertEquals((Object)TestUtils.EXECUTION_ID, (Object)exceptionResult.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.FAILED, (Object)exceptionResult.getStatus());
        Assertions.assertEquals((Object)errorMessage, (Object)exceptionResult.getStatusDetails());
    }

    @Test
    void testServiceHandlerLookupLIME() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock, this.cfExplainerServiceHandlerMock));
        Mockito.when((Object)this.limeExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(), (PredictionProvider)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TestUtils.SALIENCY_MAP));
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof LIMEExplainabilityResult));
    }

    @Test
    void testServiceHandlerLookupCounterfactuals() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock, this.cfExplainerServiceHandlerMock));
        Mockito.when((Object)this.cfExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(), (PredictionProvider)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TestUtils.COUNTERFACTUAL_RESULT));
        BaseExplainabilityResult result = (BaseExplainabilityResult)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResult)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.COUNTERFACTUAL_REQUEST, this.callbackMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof CounterfactualExplainabilityResult));
    }
}

