/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.CounterfactualDomain;
import org.kie.kogito.explainability.api.CounterfactualDomainRange;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainCollectionValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainStructureValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainValue;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.ModelIdentifier;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualResult;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.model.CounterfactualPrediction;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.tracing.typedvalue.BaseTypedValue;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CounterfactualExplainerServiceHandlerTest {
    private static final String EXECUTION_ID = UUID.randomUUID().toString();
    private static final String COUNTERFACTUAL_ID = UUID.randomUUID().toString();
    private static final String SOLUTION_ID = UUID.randomUUID().toString();
    private static final String SERVICE_URL = "serviceURL";
    private static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("resourceType", "resourceId");
    private static final Long MAX_RUNNING_TIME_SECONDS = 60L;
    private static final Long MAX_RUNNING_TIME_MILLISECONDS = MAX_RUNNING_TIME_SECONDS * 1000L;
    private CounterfactualExplainer explainer;
    private CounterfactualExplainerServiceHandler handler;

    @BeforeEach
    public void setup() {
        PredictionProviderFactory predictionProviderFactory = (PredictionProviderFactory)Mockito.mock(PredictionProviderFactory.class);
        this.explainer = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        this.handler = new CounterfactualExplainerServiceHandler(this.explainer, predictionProviderFactory, MAX_RUNNING_TIME_MILLISECONDS);
    }

    @Test
    public void testSupports() {
        Assertions.assertTrue((boolean)this.handler.supports(CounterfactualExplainabilityRequest.class));
        Assertions.assertFalse((boolean)this.handler.supports(BaseExplainabilityRequest.class));
    }

    @Test
    public void testGetPredictionWithEmptyDefinition() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)(prediction instanceof CounterfactualPrediction));
        CounterfactualPrediction counterfactualPrediction = (CounterfactualPrediction)prediction;
        Assertions.assertTrue((boolean)counterfactualPrediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getOutput().getOutputs().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getDomain().getFeatureDomains().isEmpty());
        Assertions.assertEquals((Long)counterfactualPrediction.getMaxRunningTimeSeconds(), (Long)request.getMaxRunningTimeSeconds());
    }

    @Test
    public void testGetPredictionWithFlatInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, List.of(new NamedTypedValue("input1", (TypedValue)new UnitValue("number", (JsonNode)new IntNode(20)))), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)(prediction instanceof CounterfactualPrediction));
        CounterfactualPrediction counterfactualPrediction = (CounterfactualPrediction)prediction;
        Assertions.assertEquals((int)1, (int)counterfactualPrediction.getInput().getFeatures().size());
        Optional<Feature> oInput1 = counterfactualPrediction.getInput().getFeatures().stream().filter(f -> f.getName().equals("input1")).findFirst();
        Assertions.assertTrue((boolean)oInput1.isPresent());
        Feature input1 = oInput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)input1.getType());
        Assertions.assertEquals((double)20.0, (double)input1.getValue().asNumber());
        Assertions.assertTrue((boolean)counterfactualPrediction.getOutput().getOutputs().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getDomain().getFeatureDomains().isEmpty());
        Assertions.assertEquals((Long)counterfactualPrediction.getMaxRunningTimeSeconds(), (Long)request.getMaxRunningTimeSeconds());
    }

    @Test
    public void testGetPredictionWithStructuredInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, List.of(new NamedTypedValue("input1", (TypedValue)new StructureValue("number", Map.of("input2b", new UnitValue("number", (JsonNode)new IntNode(55)))))), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, List.of(new NamedTypedValue("input1", (TypedValue)new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100)))))), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithFlatOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), List.of(new NamedTypedValue("output1", (TypedValue)new UnitValue("number", (JsonNode)new IntNode(20)))), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)(prediction instanceof CounterfactualPrediction));
        CounterfactualPrediction counterfactualPrediction = (CounterfactualPrediction)prediction;
        Assertions.assertEquals((int)1, (int)counterfactualPrediction.getOutput().getOutputs().size());
        Optional<Output> oOutput1 = counterfactualPrediction.getOutput().getOutputs().stream().filter(f -> f.getName().equals("output1")).findFirst();
        Assertions.assertTrue((boolean)oOutput1.isPresent());
        Output output1 = oOutput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output1.getType());
        Assertions.assertEquals((double)20.0, (double)output1.getValue().asNumber());
        Assertions.assertTrue((boolean)counterfactualPrediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getDomain().getFeatureDomains().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getConstraints().isEmpty());
        Assertions.assertEquals((Long)counterfactualPrediction.getMaxRunningTimeSeconds(), (Long)request.getMaxRunningTimeSeconds());
    }

    @Test
    public void testGetPredictionWithFlatOutputModelReordered() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), List.of(new NamedTypedValue("inputsAreValid", (TypedValue)new UnitValue("boolean", (JsonNode)BooleanNode.FALSE)), new NamedTypedValue("canRequestLoan", (TypedValue)new UnitValue("booelan", (JsonNode)BooleanNode.TRUE)), new NamedTypedValue("my-scoring-function", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(0.85)))), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)(prediction instanceof CounterfactualPrediction));
        CounterfactualPrediction counterfactualPrediction = (CounterfactualPrediction)prediction;
        List outputs = counterfactualPrediction.getOutput().getOutputs();
        Assertions.assertEquals((int)3, (int)outputs.size());
        Output output1 = (Output)outputs.get(0);
        Assertions.assertEquals((Object)"my-scoring-function", (Object)output1.getName());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output1.getType());
        Assertions.assertEquals((double)0.85, (double)output1.getValue().asNumber());
        Output output2 = (Output)outputs.get(1);
        Assertions.assertEquals((Object)"inputsAreValid", (Object)output2.getName());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)output2.getType());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)output2.getValue().getUnderlyingObject());
        Output output3 = (Output)outputs.get(2);
        Assertions.assertEquals((Object)"canRequestLoan", (Object)output3.getName());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)output3.getType());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)output3.getValue().getUnderlyingObject());
        Assertions.assertTrue((boolean)counterfactualPrediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getDomain().getFeatureDomains().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getConstraints().isEmpty());
        Assertions.assertEquals((Long)counterfactualPrediction.getMaxRunningTimeSeconds(), (Long)request.getMaxRunningTimeSeconds());
    }

    @Test
    public void testGetPredictionWithStructuredOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), List.of(new NamedTypedValue("input1", (TypedValue)new StructureValue("number", Map.of("input2b", new UnitValue("number", (JsonNode)new IntNode(55)))))), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), List.of(new NamedTypedValue("input1", (TypedValue)new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100)))))), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithFlatSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), List.of(new CounterfactualSearchDomain("output1", (CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("number", "number", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)new IntNode(10), (JsonNode)new IntNode(20))))), MAX_RUNNING_TIME_SECONDS);
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)(prediction instanceof CounterfactualPrediction));
        CounterfactualPrediction counterfactualPrediction = (CounterfactualPrediction)prediction;
        Assertions.assertEquals((int)1, (int)counterfactualPrediction.getDomain().getFeatureDomains().size());
        FeatureDomain featureDomain1 = (FeatureDomain)counterfactualPrediction.getDomain().getFeatureDomains().get(0);
        Assertions.assertEquals((double)10.0, (Double)featureDomain1.getLowerBound());
        Assertions.assertEquals((double)20.0, (Double)featureDomain1.getUpperBound());
        Assertions.assertTrue((boolean)counterfactualPrediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)counterfactualPrediction.getOutput().getOutputs().isEmpty());
        Assertions.assertEquals((int)1, (int)counterfactualPrediction.getConstraints().size());
        Assertions.assertTrue((boolean)((Boolean)counterfactualPrediction.getConstraints().get(0)));
        Assertions.assertEquals((Long)counterfactualPrediction.getMaxRunningTimeSeconds(), (Long)request.getMaxRunningTimeSeconds());
    }

    @Test
    public void testGetPredictionWithStructuredSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), List.of(new CounterfactualSearchDomain("input1", (CounterfactualSearchDomainValue)new CounterfactualSearchDomainStructureValue("number", Map.of("input2b", new CounterfactualSearchDomainUnitValue("number", "number", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)new IntNode(10), (JsonNode)new IntNode(20))))))), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), List.of(new CounterfactualSearchDomain("input1", (CounterfactualSearchDomainValue)new CounterfactualSearchDomainCollectionValue("number", List.of(new CounterfactualSearchDomainUnitValue("number", "number", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)new IntNode(10), (JsonNode)new IntNode(20))))))), MAX_RUNNING_TIME_SECONDS);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testCreateSucceededResult() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        CounterfactualResult counterfactuals = new CounterfactualResult(List.of(DoubleEntity.from((Feature)new Feature("input1", Type.NUMBER, new Value((Object)123.0)), (double)0.0, (double)1000.0)), List.of(new PredictionOutput(List.of(new Output("output1", Type.NUMBER, new Value((Object)555.0), 1.0)))), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);
        BaseExplainabilityResult base = this.handler.createSucceededResult(request, counterfactuals);
        Assertions.assertTrue((boolean)(base instanceof CounterfactualExplainabilityResult));
        CounterfactualExplainabilityResult result = (CounterfactualExplainabilityResult)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.SUCCEEDED, (Object)result.getStatus());
        Assertions.assertEquals((Object)CounterfactualExplainabilityResult.Stage.FINAL, (Object)result.getStage());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((Object)COUNTERFACTUAL_ID, (Object)result.getCounterfactualId());
        Assertions.assertEquals((int)1, (int)result.getInputs().size());
        Assertions.assertTrue((boolean)result.getInputs().stream().anyMatch(i -> i.getName().equals("input1")));
        NamedTypedValue input1 = (NamedTypedValue)result.getInputs().iterator().next();
        Assertions.assertEquals((Object)Double.class.getSimpleName(), (Object)input1.getValue().getType());
        Assertions.assertEquals((Object)BaseTypedValue.Kind.UNIT, (Object)input1.getValue().getKind());
        Assertions.assertEquals((double)123.0, (double)((UnitValue)input1.getValue().toUnit()).getValue().asDouble());
        Assertions.assertEquals((int)1, (int)result.getOutputs().size());
        Assertions.assertTrue((boolean)result.getOutputs().stream().anyMatch(o -> o.getName().equals("output1")));
        NamedTypedValue output1 = (NamedTypedValue)result.getOutputs().iterator().next();
        Assertions.assertEquals((Object)Double.class.getSimpleName(), (Object)output1.getValue().getType());
        Assertions.assertEquals((Object)BaseTypedValue.Kind.UNIT, (Object)output1.getValue().getKind());
        Assertions.assertEquals((double)555.0, (double)((UnitValue)output1.getValue().toUnit()).getValue().asDouble());
    }

    @Test
    public void testCreateSucceededResultWithNullPredictions() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        CounterfactualResult counterfactuals = new CounterfactualResult(Collections.emptyList(), null, true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);
        Assertions.assertThrows(NullPointerException.class, () -> this.handler.createSucceededResult(request, counterfactuals));
    }

    @Test
    public void testCreateSucceededResultWithEmptyPredictions() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        CounterfactualResult counterfactuals = new CounterfactualResult(Collections.emptyList(), Collections.emptyList(), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler.createSucceededResult(request, counterfactuals));
    }

    @Test
    public void testCreateSucceededResultWithMoreThanOnePrediction() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        CounterfactualResult counterfactuals = new CounterfactualResult(Collections.emptyList(), List.of(new PredictionOutput(List.of(new Output("output1", Type.NUMBER, new Value((Object)555.0), 1.0))), new PredictionOutput(List.of(new Output("output2", Type.NUMBER, new Value((Object)777.0), 2.0)))), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler.createSucceededResult(request, counterfactuals));
    }

    @Test
    public void testCreateIntermediateResult() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        CounterfactualResult counterfactuals = new CounterfactualResult(List.of(DoubleEntity.from((Feature)new Feature("input1", Type.NUMBER, new Value((Object)123.0)), (double)0.0, (double)1000.0)), List.of(new PredictionOutput(List.of(new Output("output1", Type.NUMBER, new Value((Object)555.0), 1.0)))), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);
        BaseExplainabilityResult base = this.handler.createIntermediateResult(request, counterfactuals);
        Assertions.assertTrue((boolean)(base instanceof CounterfactualExplainabilityResult));
        CounterfactualExplainabilityResult result = (CounterfactualExplainabilityResult)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.SUCCEEDED, (Object)result.getStatus());
        Assertions.assertEquals((Object)CounterfactualExplainabilityResult.Stage.INTERMEDIATE, (Object)result.getStage());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((Object)COUNTERFACTUAL_ID, (Object)result.getCounterfactualId());
        Assertions.assertEquals((int)1, (int)result.getInputs().size());
        Assertions.assertTrue((boolean)result.getInputs().stream().anyMatch(i -> i.getName().equals("input1")));
        NamedTypedValue input1 = (NamedTypedValue)result.getInputs().iterator().next();
        Assertions.assertEquals((Object)Double.class.getSimpleName(), (Object)input1.getValue().getType());
        Assertions.assertEquals((Object)BaseTypedValue.Kind.UNIT, (Object)input1.getValue().getKind());
        Assertions.assertEquals((double)123.0, (double)((UnitValue)input1.getValue().toUnit()).getValue().asDouble());
        Assertions.assertEquals((int)1, (int)result.getOutputs().size());
        Assertions.assertTrue((boolean)result.getOutputs().stream().anyMatch(o -> o.getName().equals("output1")));
        NamedTypedValue output1 = (NamedTypedValue)result.getOutputs().iterator().next();
        Assertions.assertEquals((Object)Double.class.getSimpleName(), (Object)output1.getValue().getType());
        Assertions.assertEquals((Object)BaseTypedValue.Kind.UNIT, (Object)output1.getValue().getKind());
        Assertions.assertEquals((double)555.0, (double)((UnitValue)output1.getValue().toUnit()).getValue().asDouble());
    }

    @Test
    public void testCreateFailedResult() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        BaseExplainabilityResult base = this.handler.createFailedResult(request, (Throwable)new NullPointerException("Something went wrong"));
        Assertions.assertTrue((boolean)(base instanceof CounterfactualExplainabilityResult));
        CounterfactualExplainabilityResult result = (CounterfactualExplainabilityResult)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.FAILED, (Object)result.getStatus());
        Assertions.assertEquals((Object)"Something went wrong", (Object)result.getStatusDetails());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((Object)COUNTERFACTUAL_ID, (Object)result.getCounterfactualId());
    }

    @Test
    public void testExplainAsyncDelegation() {
        Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
        PredictionProvider predictionProvider = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.handler.explainAsync(prediction, predictionProvider);
        ((CounterfactualExplainer)Mockito.verify((Object)this.explainer)).explainAsync((Prediction)ArgumentMatchers.eq((Object)prediction), (PredictionProvider)ArgumentMatchers.eq((Object)predictionProvider), (Consumer)ArgumentMatchers.any(Consumer.class));
    }

    @Test
    public void testExplainAsyncWithConsumerDelegation() {
        Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
        PredictionProvider predictionProvider = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.handler.explainAsync(prediction, predictionProvider, callback);
        ((CounterfactualExplainer)Mockito.verify((Object)this.explainer)).explainAsync((Prediction)ArgumentMatchers.eq((Object)prediction), (PredictionProvider)ArgumentMatchers.eq((Object)predictionProvider), (Consumer)ArgumentMatchers.eq((Object)callback));
    }
}

