/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.api.ModelIdentifier;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualResult;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

public class TestUtils {
    private static final Long MAX_RUNNING_TIME_SECONDS = 60L;
    public static final String EXECUTION_ID = UUID.randomUUID().toString();
    public static final String COUNTERFACTUAL_ID = UUID.randomUUID().toString();
    public static final String SOLUTION_ID = UUID.randomUUID().toString();
    public static final String SERVICE_URL = "localhost:8080";
    public static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("dmn", "name:namespace");
    public static final Value VALUE = new Value((Object)true);
    public static final FeatureImportance FEATURE_IMPORTANCE_1 = new FeatureImportance(new Feature("input1", Type.NUMBER, new Value((Object)1)), 0.6);
    public static final FeatureImportance FEATURE_IMPORTANCE_2 = new FeatureImportance(new Feature("input2", Type.NUMBER, new Value((Object)2)), 0.5);
    public static final List<FeatureImportance> FEATURE_IMPORTANCES = Arrays.asList(FEATURE_IMPORTANCE_1, FEATURE_IMPORTANCE_2);
    public static final Output OUTPUT = new Output("key", Type.BOOLEAN, VALUE, 1.0);
    public static final Saliency SALIENCY = new Saliency(OUTPUT, FEATURE_IMPORTANCES);
    public static final Map<String, Saliency> SALIENCY_MAP = Collections.singletonMap("key", SALIENCY);
    public static final Collection<NamedTypedValue> LIME_INPUTS = List.of(new NamedTypedValue("input1", (TypedValue)new UnitValue("string", (JsonNode)new TextNode("value"))), new NamedTypedValue("input2", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0))));
    public static final Collection<NamedTypedValue> LIME_OUTPUTS = List.of(new NamedTypedValue("output1", (TypedValue)new UnitValue("string", (JsonNode)new TextNode("output"))));
    public static final LIMEExplainabilityRequest LIME_REQUEST = new LIMEExplainabilityRequest(EXECUTION_ID, "localhost:8080", MODEL_IDENTIFIER, LIME_INPUTS, LIME_OUTPUTS);
    public static final Collection<NamedTypedValue> CF_ORIGINAL_INPUTS = List.of(new NamedTypedValue("input1", (TypedValue)new UnitValue("string", (JsonNode)new TextNode("value"))), new NamedTypedValue("input2", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0))));
    public static final Collection<NamedTypedValue> CF_GOALS = List.of(new NamedTypedValue("input1", (TypedValue)new UnitValue("string", (JsonNode)new TextNode("value"))), new NamedTypedValue("input2", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0))));
    public static final Collection<CounterfactualSearchDomain> CF_SEARCH_DOMAINS = new ArrayList<CounterfactualSearchDomain>();
    public static final CounterfactualExplainabilityRequest COUNTERFACTUAL_REQUEST = new CounterfactualExplainabilityRequest(EXECUTION_ID, "localhost:8080", MODEL_IDENTIFIER, COUNTERFACTUAL_ID, CF_ORIGINAL_INPUTS, CF_GOALS, CF_SEARCH_DOMAINS, MAX_RUNNING_TIME_SECONDS);
    public static final CounterfactualResult COUNTERFACTUAL_RESULT = new CounterfactualResult(Collections.emptyList(), Collections.emptyList(), List.of(new PredictionOutput(List.of(new Output("output1", Type.NUMBER, new Value((Object)555.0), 2.0)))), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID), 0L);

    private TestUtils() {
    }
}

