/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.ConversionUtils;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.FeatureImportanceModel;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.explainability.api.SaliencyModel;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandler;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.SimplePrediction;

@ApplicationScoped
public class LimeExplainerServiceHandler
implements LocalExplainerServiceHandler<Map<String, Saliency>, LIMEExplainabilityRequest> {
    private final LimeExplainer explainer;
    private final PredictionProviderFactory predictionProviderFactory;

    @Inject
    public LimeExplainerServiceHandler(LimeExplainer explainer, PredictionProviderFactory predictionProviderFactory) {
        this.explainer = explainer;
        this.predictionProviderFactory = predictionProviderFactory;
    }

    @Override
    public <T extends BaseExplainabilityRequest> boolean supports(Class<T> type) {
        return LIMEExplainabilityRequest.class.isAssignableFrom(type);
    }

    @Override
    public PredictionProvider getPredictionProvider(LIMEExplainabilityRequest request) {
        return this.predictionProviderFactory.createPredictionProvider(request.getServiceUrl(), request.getModelIdentifier(), request.getOutputs());
    }

    @Override
    public Prediction getPrediction(LIMEExplainabilityRequest request) {
        Collection inputs = request.getInputs();
        Collection outputs = request.getOutputs();
        PredictionInput input = new PredictionInput(ConversionUtils.toFeatureList(inputs));
        PredictionOutput output = new PredictionOutput(ConversionUtils.toOutputList(outputs));
        return new SimplePrediction(input, output);
    }

    @Override
    public BaseExplainabilityResult createSucceededResult(LIMEExplainabilityRequest request, Map<String, Saliency> result) {
        return LIMEExplainabilityResult.buildSucceeded((String)request.getExecutionId(), result.entrySet().stream().map(e -> new SaliencyModel((String)e.getKey(), ((Saliency)e.getValue()).getPerFeatureImportance().stream().map(f -> new FeatureImportanceModel(f.getFeature().getName(), Double.valueOf(f.getScore()))).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    @Override
    public BaseExplainabilityResult createIntermediateResult(LIMEExplainabilityRequest request, Map<String, Saliency> result) {
        throw new UnsupportedOperationException("Intermediate results are not supported by LIME.");
    }

    @Override
    public BaseExplainabilityResult createFailedResult(LIMEExplainabilityRequest request, Throwable throwable) {
        return LIMEExplainabilityResult.buildFailed((String)request.getExecutionId(), (String)throwable.getMessage());
    }

    public CompletableFuture<Map<String, Saliency>> explainAsync(Prediction prediction, PredictionProvider predictionProvider, Consumer<Map<String, Saliency>> intermediateResultsConsumer) {
        return this.explainer.explainAsync(prediction, predictionProvider, intermediateResultsConsumer);
    }
}

