/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.ConversionUtils;
import org.kie.kogito.explainability.api.CounterfactualDomain;
import org.kie.kogito.explainability.api.CounterfactualDomainCategorical;
import org.kie.kogito.explainability.api.CounterfactualDomainRange;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainValue;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

class ConversionUtilsTest {
    ConversionUtilsTest() {
    }

    private static NamedTypedValue getDoubleUnit(String name, double value) {
        return new NamedTypedValue(name, (TypedValue)new UnitValue("number", (JsonNode)DoubleNode.valueOf((double)value)));
    }

    private static CounterfactualSearchDomain getDoubleSearchDomain(String name, double lowerBound, double upperBound) {
        CounterfactualDomainRange range = new CounterfactualDomainRange((JsonNode)DoubleNode.valueOf((double)lowerBound), (JsonNode)DoubleNode.valueOf((double)upperBound));
        CounterfactualSearchDomainUnitValue searchDomain = new CounterfactualSearchDomainUnitValue("double", "double", Boolean.FALSE, (CounterfactualDomain)range);
        return new CounterfactualSearchDomain(name, (CounterfactualSearchDomainValue)searchDomain);
    }

    @Test
    void toFeatureDomainsConstraintsSingleElement() {
        NamedTypedValue typedValue = ConversionUtilsTest.getDoubleUnit("f-1", 20.0);
        CounterfactualSearchDomain domain = ConversionUtilsTest.getDoubleSearchDomain("f-1", 18.0, 65.0);
        List features = ConversionUtils.toFeatureList(List.of(typedValue), List.of(domain));
        Assertions.assertEquals((int)1, (int)features.size());
        Feature feature = (Feature)features.get(0);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)feature.getType());
        Assertions.assertEquals((Object)"f-1", (Object)feature.getName());
        Assertions.assertEquals((double)20.0, (double)feature.getValue().asNumber());
        Assertions.assertFalse((boolean)feature.isConstrained());
        Assertions.assertFalse((boolean)feature.getDomain().isEmpty());
        Assertions.assertEquals((double)18.0, (Double)feature.getDomain().getLowerBound());
        Assertions.assertEquals((double)65.0, (Double)feature.getDomain().getUpperBound());
    }

    @Test
    void toFeatureDomainsConstraintsMultiElement() {
        Random random = new Random();
        List values = IntStream.range(0, 10).mapToObj(i -> ConversionUtilsTest.getDoubleUnit("f-" + i, random.nextDouble())).collect(Collectors.toList());
        List domains = IntStream.range(0, 10).mapToObj(i -> ConversionUtilsTest.getDoubleSearchDomain("f-" + i, -1.0, 1.0)).collect(Collectors.toList());
        List features = ConversionUtils.toFeatureList(values, domains);
        Assertions.assertEquals((int)10, (int)features.size());
        Assertions.assertTrue((boolean)features.stream().allMatch(f -> f.getType() == Type.NUMBER));
        Assertions.assertTrue((boolean)features.stream().noneMatch(Feature::isConstrained));
        Assertions.assertTrue((boolean)features.stream().map(Feature::getDomain).noneMatch(FeatureDomain::isEmpty));
        Assertions.assertTrue((boolean)features.stream().map(Feature::getDomain).map(FeatureDomain::getLowerBound).allMatch(lb -> lb == -1.0));
        Assertions.assertTrue((boolean)features.stream().map(Feature::getDomain).map(FeatureDomain::getUpperBound).allMatch(ub -> ub == 1.0));
    }

    @Test
    void toFeatureTypedValue() {
        Feature name = ConversionUtils.toFeature((String)"name", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0)));
        Assertions.assertNotNull((Object)name);
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)name.getType());
        Assertions.assertEquals((Object)10.0, (Object)name.getValue().getUnderlyingObject());
        Assertions.assertTrue((boolean)name.isConstrained());
        Assertions.assertTrue((boolean)name.getDomain().isEmpty());
        Feature name1 = ConversionUtils.toFeature((String)"name1", (TypedValue)new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("stringValue")))));
        Assertions.assertNotNull((Object)name1);
        Assertions.assertTrue((boolean)name1.isConstrained());
        Assertions.assertTrue((boolean)name1.getDomain().isEmpty());
        Assertions.assertEquals((Object)"name1", (Object)name1.getName());
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)name1.getType());
        Assertions.assertTrue((boolean)(name1.getValue().getUnderlyingObject() instanceof List));
        List features = (List)name1.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)features.size());
        Assertions.assertEquals((Object)Type.TEXT, (Object)((Feature)features.get(0)).getType());
        Assertions.assertEquals((Object)"stringValue", (Object)((Feature)features.get(0)).getValue().getUnderlyingObject());
        List<UnitValue> values = List.of(new UnitValue("number", (JsonNode)new DoubleNode(0.0)), new UnitValue("number", (JsonNode)new DoubleNode(1.0)));
        Feature collectionFeature = ConversionUtils.toFeature((String)"name", (TypedValue)new CollectionValue("list", values));
        Assertions.assertNotNull((Object)collectionFeature);
        Assertions.assertEquals((Object)"name", (Object)collectionFeature.getName());
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)collectionFeature.getType());
        Assertions.assertTrue((boolean)(collectionFeature.getValue().getUnderlyingObject() instanceof List));
        List objects = (List)collectionFeature.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)2, (int)objects.size());
        for (Feature f : objects) {
            Assertions.assertNotNull((Object)f);
            Assertions.assertNotNull((Object)f.getName());
            Assertions.assertNotNull((Object)f.getType());
            Assertions.assertEquals((Object)Type.NUMBER, (Object)f.getType());
            Assertions.assertNotNull((Object)f.getValue());
        }
    }

    @Test
    void testNestedCollection() {
        ArrayList<StructureValue> depthTwoOne = new ArrayList<StructureValue>(2);
        depthTwoOne.add(new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("value one")))));
        depthTwoOne.add(new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("value two")))));
        ArrayList<StructureValue> depthTwoTwo = new ArrayList<StructureValue>(2);
        depthTwoTwo.add(new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("value three")))));
        depthTwoTwo.add(new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("value four")))));
        CollectionValue depthOneLeft = new CollectionValue("list", depthTwoOne);
        CollectionValue depthOneRight = new CollectionValue("list", depthTwoTwo);
        ArrayList<CollectionValue> depthOne = new ArrayList<CollectionValue>(2);
        depthOne.add(depthOneLeft);
        depthOne.add(depthOneRight);
        CollectionValue value = new CollectionValue("list", depthOne);
        Feature collectionFeature = ConversionUtils.toFeature((String)"name", (TypedValue)value);
        Assertions.assertNotNull((Object)collectionFeature);
        Assertions.assertEquals((Object)"name", (Object)collectionFeature.getName());
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)collectionFeature.getType());
        Assertions.assertTrue((boolean)(collectionFeature.getValue().getUnderlyingObject() instanceof List));
        List deepFeatures = (List)collectionFeature.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)2, (int)deepFeatures.size());
        for (Feature f : deepFeatures) {
            Assertions.assertNotNull((Object)f);
            Assertions.assertNotNull((Object)f.getName());
            Assertions.assertNotNull((Object)f.getType());
            Assertions.assertEquals((Object)Type.COMPOSITE, (Object)f.getType());
            Assertions.assertNotNull((Object)f.getValue());
            List nestedOneValues = (List)f.getValue().getUnderlyingObject();
            for (Feature nestedOneValue : nestedOneValues) {
                Assertions.assertNotNull((Object)nestedOneValue);
                Assertions.assertNotNull((Object)nestedOneValue.getName());
                Assertions.assertNotNull((Object)nestedOneValue.getType());
                Assertions.assertEquals((Object)Type.COMPOSITE, (Object)nestedOneValue.getType());
                Assertions.assertNotNull((Object)nestedOneValue.getValue());
                List nestedTwoValues = (List)nestedOneValue.getValue().getUnderlyingObject();
                for (Feature nestedTwoValue : nestedTwoValues) {
                    Assertions.assertNotNull((Object)nestedTwoValue);
                    Assertions.assertNotNull((Object)nestedTwoValue.getName());
                    Assertions.assertNotNull((Object)nestedTwoValue.getType());
                    Assertions.assertEquals((Object)Type.TEXT, (Object)nestedTwoValue.getType());
                    Assertions.assertNotNull((Object)nestedTwoValue.getValue());
                    Assertions.assertTrue((boolean)nestedTwoValue.getValue().asString().contains("value"));
                }
            }
        }
    }

    @Test
    void testToList() {
        Assertions.assertEquals(Collections.emptyList(), (Object)ConversionUtils.toList((JsonObject)null, (a, b) -> a));
        Assertions.assertEquals(Collections.emptyList(), (Object)ConversionUtils.toList((Map)null, (a, b) -> a));
    }

    @Test
    void toOutputObject() {
        Output name = ConversionUtils.toOutput((String)"name", (Object)10.0);
        Assertions.assertNotNull((Object)name);
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)name.getType());
        Assertions.assertEquals((Object)10.0, (Object)name.getValue().getUnderlyingObject());
        JsonObject jsonObject = new JsonObject(Collections.singletonMap("key", 10.0));
        Output output = ConversionUtils.toOutput((String)"output", (Object)jsonObject);
        Assertions.assertNotNull((Object)output);
        Assertions.assertEquals((Object)"output", (Object)output.getName());
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)output.getType());
        Assertions.assertEquals((Object)10.0, (Object)name.getValue().getUnderlyingObject());
    }

    @Test
    void toOutputTypedValue() {
        Output name = ConversionUtils.toOutput((String)"name", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0)));
        Assertions.assertNotNull((Object)name);
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)name.getType());
        Assertions.assertEquals((Object)10.0, (Object)name.getValue().getUnderlyingObject());
        Output name1 = ConversionUtils.toOutput((String)"name1", (TypedValue)new StructureValue("complex", Collections.singletonMap("key", new UnitValue("string1", (JsonNode)new TextNode("stringValue")))));
        Assertions.assertNotNull((Object)name1);
        Assertions.assertEquals((Object)"name1", (Object)name1.getName());
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)name1.getType());
        Assertions.assertTrue((boolean)(name1.getValue().getUnderlyingObject() instanceof List));
        List outputs = (List)name1.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)outputs.size());
        Assertions.assertEquals((Object)Type.TEXT, (Object)((Output)outputs.get(0)).getType());
        Assertions.assertEquals((Object)"stringValue", (Object)((Output)outputs.get(0)).getValue().getUnderlyingObject());
        List<UnitValue> values = List.of(new UnitValue("number", (JsonNode)new DoubleNode(0.0)), new UnitValue("number", (JsonNode)new DoubleNode(1.0)));
        Assertions.assertNotNull((Object)ConversionUtils.toOutput((String)"name", (TypedValue)new CollectionValue("list", values)));
    }

    @Test
    void testToTypeValuePairObject() {
        this.commonTypeValuePairObject("string", Type.TEXT, "string");
        this.commonTypeValuePairObject(10.0, Type.NUMBER, 10.0);
        this.commonTypeValuePairObject(true, Type.BOOLEAN, true);
        Assertions.assertFalse((boolean)ConversionUtils.toTypeValuePair((Object)new Object()).isPresent());
    }

    private void commonTypeValuePairObject(Object input, Type type, Object value) {
        Optional result = ConversionUtils.toTypeValuePair((Object)input);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)type, (Object)((Pair)result.get()).getKey());
        Assertions.assertEquals((Object)value, (Object)((Value)((Pair)result.get()).getValue()).getUnderlyingObject());
    }

    @Test
    void testToTypeValuePairJson() {
        this.commonTypeValuePairJson((JsonNode)new TextNode("string"), Type.TEXT, "string");
        this.commonTypeValuePairJson((JsonNode)new DoubleNode(10.0), Type.NUMBER, 10.0);
        this.commonTypeValuePairJson((JsonNode)BooleanNode.TRUE, Type.BOOLEAN, true);
        Assertions.assertFalse((boolean)ConversionUtils.toTypeValuePair((JsonNode)new ObjectNode(JsonNodeFactory.instance)).isPresent());
    }

    private void commonTypeValuePairJson(JsonNode input, Type type, Object value) {
        Optional result = ConversionUtils.toTypeValuePair((JsonNode)input);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)type, (Object)((Pair)result.get()).getKey());
        Assertions.assertEquals((Object)value, (Object)((Value)((Pair)result.get()).getValue()).getUnderlyingObject());
    }

    @Test
    void testToFeatureDomain_UnitRangeInteger() {
        FeatureDomain featureDomain = ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("int", "int", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)IntNode.valueOf((int)18), (JsonNode)IntNode.valueOf((int)65))));
        Assertions.assertTrue((boolean)(featureDomain instanceof NumericalFeatureDomain));
        NumericalFeatureDomain numericalFeatureDomain = (NumericalFeatureDomain)featureDomain;
        Assertions.assertEquals((double)18.0, (Double)numericalFeatureDomain.getLowerBound());
        Assertions.assertEquals((double)65.0, (Double)numericalFeatureDomain.getUpperBound());
        Assertions.assertNull((Object)numericalFeatureDomain.getCategories());
    }

    @Test
    void testToFeatureDomain_UnitRangeDouble() {
        FeatureDomain featureDomain = ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("double", "double", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)DoubleNode.valueOf((double)-273.15), (JsonNode)DoubleNode.valueOf((double)Double.MAX_VALUE))));
        Assertions.assertTrue((boolean)(featureDomain instanceof NumericalFeatureDomain));
        NumericalFeatureDomain numericalFeatureDomain = (NumericalFeatureDomain)featureDomain;
        Assertions.assertEquals((double)-273.15, (Double)numericalFeatureDomain.getLowerBound());
        Assertions.assertEquals((double)Double.MAX_VALUE, (Double)numericalFeatureDomain.getUpperBound());
        Assertions.assertNull((Object)numericalFeatureDomain.getCategories());
    }

    @Test
    void testToFeatureDomain_UnitRangeString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("string", "string", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainRange((JsonNode)TextNode.valueOf((String)"A"), (JsonNode)TextNode.valueOf((String)"Z")))));
    }

    @Test
    void testToFeatureDomain_UnitCategoricalNumber() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("string", "string", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainCategorical(List.of(IntNode.valueOf((int)1), IntNode.valueOf((int)2))))));
    }

    @Test
    void testToFeatureDomain_UnitCategoricalString() {
        FeatureDomain featureDomain = ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("string", "string", Boolean.valueOf(true), (CounterfactualDomain)new CounterfactualDomainCategorical(List.of(TextNode.valueOf((String)"Black"), TextNode.valueOf((String)"White")))));
        Assertions.assertTrue((boolean)(featureDomain instanceof CategoricalFeatureDomain));
        CategoricalFeatureDomain categoricalFeatureDomain = (CategoricalFeatureDomain)featureDomain;
        Assertions.assertEquals((int)2, (int)categoricalFeatureDomain.getCategories().size());
        Assertions.assertTrue((boolean)categoricalFeatureDomain.getCategories().containsAll(List.of("White", "Black")));
        Assertions.assertNull((Object)categoricalFeatureDomain.getLowerBound());
        Assertions.assertNull((Object)categoricalFeatureDomain.getUpperBound());
    }

    @Test
    void testToFeatureDomain_UnitFixedNumber() {
        FeatureDomain featureDomain = ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("integer", "integer", Boolean.valueOf(true), null));
        Assertions.assertTrue((boolean)(featureDomain instanceof EmptyFeatureDomain));
    }

    @Test
    void testToFeatureDomain_UnitFixedString() {
        FeatureDomain featureDomain = ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("string", "string", Boolean.valueOf(true), null));
        Assertions.assertTrue((boolean)(featureDomain instanceof EmptyFeatureDomain));
    }

    @Test
    void testToFeatureDomain_UnitNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConversionUtils.toFeatureDomain((CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("integer", "integer", Boolean.valueOf(true), new CounterfactualDomain(){})));
    }
}

